#include <Bvor10.h>

// *********************************
// *** BSatz.CPP ******************
// *********************************

///#include <BSatz.h>

// *********************************
// *** Konstruktor *****************
// *********************************
BSatz::BSatz() {
  name = "leer";
  wert = false;
  talk = false;
}

// *********************************
// *** Eigenschaften setzen ********
// *********************************
void BSatz::init(String aName, boolean aWert) {
  setName(aName);
  setWert(aWert);
}

// *********************************
// *** Namen setzen ****************
// *********************************
String BSatz::setName(String aName) {
  name = aName;
  return name;
}

// *********************************
// *** Namen auslesen **************
// *********************************
String BSatz::getName() {
  return name;
}

// *********************************
// *** Wert setzen *****************
// *********************************
boolean BSatz::setWert(boolean aWert) {
  wert = aWert;
  return wert;
}

// *********************************
// *** Wert auslesen ***************
// *********************************
boolean BSatz::getWert() {
  return wert;
}


// *********************************
// *** Quaselmodus managen *********
// *********************************
void BSatz::setTalk(bool wie) {
  talk = wie;
}

// *********************************
// *** Quaselmodus abfragen ********
// *********************************
bool BSatz::getTalk() {
  return talk;
}

// *********************************
// *** Bvor10.cpp ******************
// *********************************

// *********************************
// *** Index prüfen ****************
// *********************************

int Bvor10::cNr(int nr) {
  if ((nr >= 0) && (nr < bpZahl)) return nr;
  else {
    Serial.print("Parameter: Index out of Range!");
    return -1;
  }
}

// *********************************
// *** Name der Voreinstellungen im Flash
// *********************************
void Bvor10::setPName(String aName) {
  pName = aName;
}

// *********************************
// *** Name der Daten im Flash liefern
// *********************************
String Bvor10::getPName() {
  return pName;
}

// *********************************
// *** Quaselmodus wechseln ********
// *********************************
void Bvor10::setTalk(bool wie) {
  talk = wie;
  for (int t = 0; t < bpZahl; t++) par[t].setTalk(wie);
}

// *********************************
// *** Quaselzustand abfragen ******
// *********************************
bool Bvor10::getTalk() {
  return talk;
}

// *********************************
// *** Voreinstellungen im Flash ablegen
// *********************************
bool Bvor10::writeThem() {
  if (talk) Serial.println("Parameterwerte schreiben!");
  myPrefs.begin(getPName().c_str(), false);  // Typumwandlung const char * erwartet
  for (int i = 0; i < bpZahl; i++) {
    myPrefs.putString(String(2 * i).c_str(), par[i].getName().c_str());
    myPrefs.putBool(String(2 * i + 1).c_str(), par[i].getWert());  
    if (talk) {
      Serial.print("Name:" + par[i].getName());
      Serial.println(" Wert:" + String(par[i].getWert()));
    }
  }
  myPrefs.end();
  dirty =  false;
  return true;
}

// *********************************
// *** Voreinstellungen aus Flash lesen
// *********************************
bool Bvor10::readThem() {
  bool ok = true;
  if (talk) Serial.println("B-Parameterwerte aus Flash lesen!");
  myPrefs.begin(getPName().c_str(), false);  // Typumwandlung const char * erwartet
  for (int i = 0; i < bpZahl; i++) {
    par[i].setName(myPrefs.getString(String(2 * i).c_str()));
    boolean tmp = myPrefs.getBool(String(2 * i + 1).c_str()); 
    par[i].setWert(tmp);   
    if ((myPrefs.getString(String(2 * i + 0).c_str()).length() == 0)) ok = false;
      if (talk) {
       Serial.print("Name:" + par[i].getName());
       if (par[i].getWert()) Serial.println(" Wert:1");
       else Serial.println(" Wert:0");
      }
  }
  myPrefs.end();
  dirty =  false;
  return ok;
}

// *********************************
// *** Voreinstellungen geändert? **
// *********************************

boolean Bvor10::isDirty(){
  return dirty;
}

// *********************************
// *** Pref-Partition löschen ******
// *********************************
void Bvor10::killThemAll() {
  nvs_flash_erase();  // erase the NVS partition and...
  nvs_flash_init();   // initialize the NVS partition.
  delay(100);
}

// *********************************
// *** Einen Satz initialisieren ***
// *********************************
void Bvor10::init(int aNr, String aName, boolean aWert){
  par[aNr].setName(aName);
  par[aNr].setWert(aWert);
}

// *********************************
// *** Daten direkt lesen **********
// *********************************
String Bvor10::getName(int nr) {
  if (cNr(nr) != -1) return par[nr].getName();
  else return "Error";
}

// *********************************
// *** Daten direkt lesen **********
// *********************************
boolean Bvor10::getWert(int nr) {
  if (cNr(nr) != -1) return par[nr].getWert();
  else return 0;
}


// *********************************
// *** Daten schreiben, Name *******
// *********************************
String Bvor10::setName(int nr, String aName) {
  if (cNr(nr) != -1) {
    String tmp = par[nr].getName();
    par[nr].setName(aName);
    if (aName != tmp) dirty = true;
  }
  return par[nr].getName();
}

// *********************************
// *** Daten schreiben, Wert *******
// *********************************
boolean Bvor10::setWert(int nr, boolean aWert) {
  if (cNr(nr) != -1) {
    int tmp = par[nr].getWert();
    par[nr].setWert(aWert);
    if (aWert != tmp) dirty = true;
  }
  return par[nr].getWert();
}
