 #include <Ivor10.h>

// *********************************
// *** Wert_32.CPP ******************
// *********************************

///#include < >

// *********************************
// *** Konstruktor *****************
// *********************************
 Wert_32::Wert_32() {
  name = "leer";
  min = 0;
  max = 4095;
  wert = 1;
  talk = false;
}

// *********************************
// *** Eigenschaften setzen ********
// *********************************
void Wert_32::init(String aName, int32_t amin, int32_t amax, int32_t aWert) {
  setName(aName);
  setMax(amax);
  setMin(amin);
  setWert(aWert);
}

// *********************************
// *** Namen setzen ****************
// *********************************
String Wert_32::setName(String aName) {
  name = aName;
  return name;
}

// *********************************
// *** Namen auslesen **************
// *********************************
String Wert_32::getName() {
  return name;
}

// *********************************
// *** Wert setzen *****************
// *********************************
int32_t Wert_32::setWert(int32_t aWert) {
  if ((aWert >= min) && (aWert <= max))
    wert = aWert;
  else {
    if (talk) {
      Serial.print("Wert ");
      Serial.print(aWert);
      Serial.print(" ist falsch, erlaubt:");
      Serial.print(min);
      Serial.print(" bis ");
      Serial.println(max);
    }
    wert = min;
  }
  return wert;
}

// *********************************
// *** Wert auslesen ***************
// *********************************
int32_t Wert_32::getWert() {
  return wert;
}

// *********************************
// *** max setzen ******************
// *********************************
int32_t Wert_32::setMax(int32_t aMax) {
  if ((aMax >= minInt) && (aMax <= maxInt)) max = aMax;
  else if (talk) {
    Serial.print("  Max ist falsch : ");
    Serial.println(aMax);
  }
  return max;
}

// *********************************
// *** max auslesen *****************
// *********************************
int32_t Wert_32::getMax() {
  return max;
}


// *********************************
// *** min setzen ******************
// *********************************
int32_t Wert_32::setMin(int32_t aMin) {
  if ((aMin >= minInt) && (aMin <= maxInt)) min = aMin;
  else if (talk) {
    Serial.print("  Min ist falsch : ");
    Serial.println(aMin);
  }
  return min;
}

// *********************************
// *** min auslesen ****************
// *********************************
int32_t Wert_32::getMin() {
  return min;
}

// *********************************
// *** Quaselmodus managen *********
// *********************************
void Wert_32::setTalk(bool wie) {
  talk = wie;
}

// *********************************
// *** Quaselmodus abfragen ********
// *********************************
bool Wert_32::getTalk() {
  return talk;
}

// *********************************
// *** Ivor10.cpp ******************
// *********************************

// *********************************
// *** Index prüfen ****************
// *********************************

int Ivor10::cNr(int nr) {
  if ((nr >= 0) && (nr < ipZahl)) return nr;
  else {
    Serial.print("Parameter: Index out of Range!");
    return -1;
  }
}

// *********************************
// *** Name der Voreinstellungen im Flash
// *********************************
void Ivor10::setPName(String aName) {
  pName = aName;
}

// *********************************
// *** Name der Daten im Flash liefern
// *********************************
String Ivor10::getPName() {
  return pName;
}

// *********************************
// *** Quaselmodus wechseln ********
// *********************************
void Ivor10::setTalk(bool wie) {
  talk = wie;
  for (int t = 0; t < ipZahl; t++) par[t].setTalk(wie);
}

// *********************************
// *** Quaselzustand abfragen ******
// *********************************
bool Ivor10::getTalk() {
  return talk;
}

// *********************************
// *** Voreinstellungen im Flash ablegen
// *********************************
bool Ivor10::writeThem() {
  if (talk) Serial.println("Parameterwerte schreiben!");
  myPrefs.begin(getPName().c_str(), false);  // Typumwandlung const char * erwartet
  for (int i = 0; i < ipZahl; i++) {
    //  myPrefs.putInt(par.par[i].getName().c_str(), par.par[i].getWert());
    myPrefs.putString(String(4 * i).c_str(), par[i].getName().c_str());
    myPrefs.putInt(String(4 * i + 1).c_str(), par[i].getMin());
    myPrefs.putInt(String(4 * i + 2).c_str(), par[i].getMax());
    myPrefs.putInt(String(4 * i + 3).c_str(), par[i].getWert());
    if (talk) {
      Serial.print("Name:" + par[i].getName());
      Serial.println(" Wert:" + String(par[i].getWert()));
    }
  }
  myPrefs.end();
  dirty =  false;
  return true;
}

// *********************************
// *** Voreinstellungen aus Flash lesen
// *********************************
bool Ivor10::readThem() {
  bool ok = true;
  if (talk) Serial.println("Parameterwerte aus Flash lesen!");
  myPrefs.begin(getPName().c_str(), false);  // Typumwandlung const char * erwartet
  for (int i = 0; i < ipZahl; i++) {
    //  myPrefs.putInt(par.par[i].getName().c_str(), par.par[i].getWert());
    par[i].setName(myPrefs.getString(String(4 * i).c_str()));
    par[i].setMin(myPrefs.getInt(String(4 * i + 1).c_str(), -32768));
    par[i].setMax(myPrefs.getInt(String(4 * i + 2).c_str(), -32768));
    par[i].setWert(myPrefs.getInt(String(4 * i + 3).c_str(), -32768));
    if ((par[i].getMin() == -32768) || (par[i].getMax() == -327668)
        || (par[i].getWert() == -32768) || (par[i].getName().length() == 0)) ok = false;
    if (talk) {
      Serial.print("Name:" + par[i].getName());
      Serial.print(" Min:" + String(par[i].getMin()));
      Serial.print(" Max:" + String(par[i].getMax()));
      Serial.println(" Wert:" + String(par[i].getWert()));
    }
  }
  myPrefs.end();
  dirty = false;
  return ok;
}

// *********************************
// *** Etwas geändert? *************
// *********************************
bool Ivor10::isDirty(){
  return dirty;
}

// *********************************
// *** Pref-Partitiom löschen ******
// *********************************
void Ivor10::killThemAll() {
  nvs_flash_erase();  // erase the NVS partition and...
  nvs_flash_init();   // initialize the NVS partition.
  delay(100);
}

// *********************************
// *** Daten direkt lesen **********
// *********************************
String Ivor10::getName(int nr) {
  if (cNr(nr) != -1) return par[nr].getName();
  else return "Error";
}

// *********************************
// *** Daten direkt lesen **********
// *********************************
int32_t Ivor10::getWert(int nr) {
  if (cNr(nr) != -1) return par[nr].getWert();
  else return 0;
}

// *********************************
// *** Daten direkt lesen **********
// *********************************
int32_t Ivor10::getMin(int nr) {
  if (cNr(nr) != -1) return par[nr].getMin();
  else return 0;
}

// *********************************
// *** Daten direkt lesen **********
// *********************************
int32_t Ivor10::getMax(int nr) {
  if (cNr(nr) != -1) return par[nr].getMax();
  else return 0;
}

// *********************************
// *** Daten schreiben, Name *******
// *********************************
String Ivor10::setName(int nr, String aName) {
  if (cNr(nr) != -1) {
    String tmp = par[nr].getName();
    par[nr].setName(aName);
    if (aName != tmp) dirty = true;
  }
  return par[nr].getName();
}

// *********************************
// *** Daten schreiben, Wert *******
// *********************************
int32_t Ivor10::setWert(int nr, int32_t aWert) {
  if (cNr(nr) != -1) {
    int tmp = par[nr].getWert();
    par[nr].setWert(aWert);
    if (aWert != tmp) dirty = true;
  }
  return par[nr].getWert();
}

// *********************************
// *** Daten schreiben, Min ********
// *********************************
int32_t Ivor10::setMin(int nr, int32_t aMin) {
  if (cNr(nr) != -1) {
    int tmp = par[nr].getMin();
    par[nr].setMin(aMin);
    if (aMin != tmp) dirty = true;
  }
  return par[nr].getMin();
}

// *********************************
// *** Daten schreiben, Max ********
// *********************************
int32_t Ivor10::setMax(int nr, int32_t aMax) {
  if (cNr(nr) != -1) {
    int tmp = par[nr].getMax();
    par[nr].setMax(aMax);
    if (tmp != aMax) dirty = true;
  }
  return par[nr].getMax();
}


