// **********************************************
// *** 10 Voreinstellunge int16_t im Flash ******
// *** Vereinfachteer Zugriff über Funktionen ***
// **********************************************

#define ipZahl 10  // Hier steht die Anzahl der Datensätze

#ifndef Ivor10_h
#define Ivor10h_h

#include <ESP.h>
// include <arduino.h>

#ifndef Wert_32_h
#define Wert_32_h

// *********************************
// *** Zweite Klasse Wert_32 *******
// *** Ein Datensatz der Prefs. ****
// *********************************

// *********************************
// *** Wert_32.h *******************
// *********************************

#define minInt INT32_MIN
#define maxInt INT32_MAX

class Wert_32 {
private:
  String name;
  int32_t wert;
  int32_t min;
  int32_t max;
  bool talk;

public:
  Wert_32();
  void init(String aName, int32_t amin, int32_t amax, int32_t aWert);
  int32_t setWert(int32_t aWert);
  int32_t getWert();
  int32_t setMax(int32_t aMax);
  int32_t getMax();
  int32_t setMin(int32_t aMin);
  int32_t getMin();
  String setName(String aName);
  String getName();
  void setTalk(bool wie);
  bool getTalk();
};  // Klassendefinition
#endif


// *** Hier folgen die Prefs *******
// *** Als "Vor"einstellungen benannt

#include <nvs_flash.h>
#include <Preferences.h>

// *********************************
// *** Klasse Ivor10 ***************
// *********************************

// *********************************
// *** Preferenzen mit "Zubehör" ***
// *********************************

const int anz = ipZahl;

class Ivor10 {
private:
  Wert_32 par[ipZahl];           // Zahl der Datensätze in den Preferenzen
  String pName = "MyPrefsName";  // Name der Prfeferencen
  Preferences myPrefs;           //
  boolean talk = false;          //
  int cNr(int nr);               //
  bool dirty;			 // Es wurde was geändert

public:                          //
  void setPName(String name);    // Name dieses Satzes an Voreinstellungen
  String getPName();             //
  void setTalk(bool wie);        // Quaselmodus
  bool getTalk();                //
  bool writeThem();              // Diese Voreinstellungen dauerhaft sichern
  bool readThem();               // Voreibnstellungen dieses Namens lesen
  bool isDirty();
  void killThemAll();            // Löscht alle Prefs der Partition
  String getName(int nr);
  int32_t getWert(int nr);
  int32_t getMin(int nr);
  int32_t getMax(int nr);
  String setName(int nr, String aName);
  int32_t setWert(int nr, int32_t aWert);
  int32_t setMin(int nr, int32_t aMin);
  int32_t setMax(int nr, int32_t aMax);
};
#endif
