#include <Svor10.h>

//#include <StrPar.h> // Entfällt hier

//*********************************************************
//*** Klasse für Stringparameter, bestehend aus Name und Wert
//*********************************************************

//*** Konstruktor *****************************************
StrPar::StrPar() {
}

//*** Initialisierer **************************************
void StrPar::init(String aName, String aWert) {
  name = aName;
  wert = aWert;
  if (talk) Serial.println(name + " " + wert + "übernommen");
  return;
}

//*** Parametername holen *********************************
String StrPar::getName() {
  if (talk) Serial.println(name + " geholt");
  return name;
}

//*** Parametername setzen ********************************
String StrPar::setName(String aName) {
  name = aName;
  if (talk) Serial.println(name + " gesetzt");
  return name;
}

//*** Parameterwert holen *********************************
String StrPar::getWert() {
  if (talk) Serial.println(wert + " geholt");
  return wert;
}

//*** Parameterwert setzen ********************************
String StrPar::setWert(String aWert) {
  wert = aWert;
  if (talk) Serial.println(wert + " gesetzt");
  return wert;
}

//*** Quaselmodus setzen
bool StrPar::setTalk(bool wie) {
  talk = wie;
  return wie;
}
// *** Ende Implementation von StrPar ***

// #include <Svor.h>

//*********************************************************
//*** Svor, Ganzer Parametersatz **************************
//*********************************************************

//*** Konstruktor, hier nicht verwendet *******************
Svor10::Svor10() {
}

//*** Namen des Parametersatzes im NV-RAM festlegen ********
void Svor10::setPName(String aName) {
  pName = aName;
  if (talk) Serial.println(pName + "als Name des Parametersatzes übernommen");
}

//*** Namen des Parametersatzes im NV-RAM abfragen ********
String Svor10::getPName() {
  return pName;
}

//*** Quaselmodus schalten *********************************
void Svor10::setTalk(bool wie) {
  talk = wie;
  for (int k = 0; k < spZahl; k++) par[k].setTalk(wie);
}

//*** Quaselmodus abfragen *********************************
bool Svor10::getTalk() {
  return talk;
}

//*** Parametersatz in NV-RAM schreiben *******************
bool Svor10::writeThem() {
  myPrefs.begin(getPName().c_str(), false);
  for (int i = 0; i < spZahl; i++) {
    myPrefs.putString(String(2 * i + 0).c_str(), par[i].getName());
    myPrefs.putString(String(2 * i + 1).c_str(), par[i].getWert());
  }
  myPrefs.end();
  dirty =  false;
  return true;
}

//*** Parametersatzes aus NV-RAM lesen ********************
bool Svor10::readThem() {
  bool ok = true;
  myPrefs.begin(getPName().c_str(), false);
  for (int i = 0; i < spZahl; i++) {
    par[i].setName(myPrefs.getString(String(2 * i + 0).c_str()));
    par[i].setWert(myPrefs.getString(String(2 * i + 1).c_str()));
    if ((myPrefs.getString(String(2 * i + 0).c_str()).length() == 0) 
      ||(myPrefs.getString(String(2 * i + 1).c_str()).length() == 0)) ok = false;
 }
  myPrefs.end();
  dirty = false;
  return ok;
}

//*** Wurde wa<s verändert? *******************************
bool Svor10::isDirty(){
  return dirty;
}

//*** Alles in der verwendeten Partition löschen **********
void Svor10::killThemAll() {
  nvs_flash_erase();  // erase the NVS partition and...
  nvs_flash_init();   // initialize the NVS partition.
  delay(100);
}

//*** Index für Parameterfeld prüfen ***********************
int Svor10::cNr(int aNr) {
  if ((aNr >= 0) && (aNr < spZahl)) return aNr;
  else {
    Serial.println("Index-Error!");
    return -1;
  }
}

//*** Name, Parameter direkt setzen *************************
String Svor10::setName(int aNr, String aName) {
  if (cNr(aNr) == -1) return "Error!";
  String tmp = par[aNr].getName();
  par[aNr].setName(aName);
  if (tmp != aName) dirty = true;
  return aName;
}

//*** Name, Parameter direkt lesen **************************
String Svor10::getName(int aNr) {
  if (cNr(aNr) == -1) return "Error!";
  else return par[aNr].getName();
}

//*** Wert, Parameter direkt setzen *************************
String Svor10::setWert(int aNr, String aWert) {
  if (cNr(aNr) == -1) return "Error";
  String tmp = par[aNr].getWert();
  par[aNr].setWert(aWert);
  if (tmp != aWert) dirty = true;
  return aWert;
}

//*** Wert, Parameter direkt lesen ***************************
String Svor10::getWert(int aNr) {
  if (cNr(aNr) == -1) return "Error!";
  else return par[aNr].getWert();
}