// *********** Daten für Switch.cpp *********************************************
#include <Switch.h>
// ******************************************************************************
// ******* Setup I2C-Modus ******************************************************
// ******************************************************************************

int Switch::setup(int pPortAdr, int* pPortInhalt, int pBit) {
  if ((pBit < 0) || (pBit > 7)) {
    Serial.println("Fehlerhafte Bit-Parameter beim Setup");
    return -1;
  }
  Serial.print("I2C-Setup mit Portadresse "); Serial.print(pPortAdr);
  Serial.print(" Bit "); Serial.println(pBit);

  lPortAdr = pPortAdr;
  lPortInhalt = pPortInhalt;
  lBit = pBit;
  if (rptSwitch) {
    Serial.println();
    Serial.print("Lokale Portadresse: "); Serial.print(lPortAdr);
    Serial.print(" Lokaler Portinhalt: "); Serial.print(*lPortInhalt);
  }
  modus = I2CM;
  return 0;
}



// ******************************************************************************
// *********** Setup für Benutzung direkter Ports *******************************
// ******************************************************************************

int Switch::setup(int pPortAdr) {
   Serial.print("Direktes Port-Setup mit "); Serial.println(pPortAdr);
 lPortAdr = pPortAdr;
  pinMode(lPortAdr, OUTPUT);
  digitalWrite(lPortAdr, LOW);
  modus = direktS;
  if (rptSwitch) {
    Serial.print("Lokale Portadresse 1:"); Serial.println(lPortAdr);
  }
  return 0;
}


// ******************************************************************************
// ************ Reportmodus setzen **********************************************
// ******************************************************************************

void Switch::setReport(boolean art) {
  rptSwitch = art;
  Serial.print(" Meldungen: "); Serial.println(rptSwitch);
}


// ******************************************************************************
// ********* Aus, Portausgabe ***************************************************
// ******************************************************************************

void Switch::aus() {
  if (rptSwitch) Serial.println("Ausschalten!");
  myTimer.setzeLaufzeit(0);
  if (modus == direktS) {                                                        // Aus: Direktmodus
    digitalWrite(lPortAdr, LOW);                                                 // Direkt in die Ports scchreiben
  }
  else {                                                                         // Aus: I2C-Modus
    int tmp = *lPortInhalt;                                                      // Alten Porttinaus lesen
    if (rptSwitch) 
    {
       Serial.print("Vorher Port :");
       Serial.println(tmp);
    }  
    tmp &= ~(1 << lBit);                                                         // Bit zurücksetzen
    *lPortInhalt = tmp;                                                          // Portinhalt aktualisieren...
    if (rptSwitch) 
    {
       Serial.print("Nachher Port:");
       Serial.println(tmp);
    }  
    toIC(lPortAdr, *lPortInhalt);                                                // ... und ausgeben
  }
  state = false;
}


// ******************************************************************************
// ************* Ein, Portausgabe ***********************************************
// ******************************************************************************

void Switch::an() {
  if (rptSwitch) Serial.println("Einschalten!");
  if (modus == direktS) {                                                        // Direkte Ausgabe:
    digitalWrite(lPortAdr, HIGH);                                                // Hier einschalten
  }
  else {                                                                         // I2C-Modus:
    int tmp = *lPortInhalt;                                                      // Portinhalt lesen
    if (rptSwitch) 
    {
       Serial.print("Vorher Port :");
       Serial.println(tmp);
    }  
    tmp |= (1 << lBit);                                                          // Passendes Bit setzen
    if (rptSwitch) 
    {
       Serial.print("Nachher Port:");
       Serial.println(tmp);
    }
    *lPortInhalt = tmp;                                                          // Portinhalt abliefern
    toIC(lPortAdr, *lPortInhalt);                                                // Ausgabe auf Port
  }
  state = true;
}



// ******************************************************************************
// ********** Zeitschaltuhr *****************************************************
// ******************************************************************************

void Switch::an(int wielange) {
  if (wielange <= 0) {
    Serial.println("Ungültige Zeitlänge für Timer!");
    return;
  }
  myTimer.start(wielange);
  an();                                                                          // Zeitschalter gestartet
  if (rptSwitch) {
    Serial.print("Eingeschaltet für "); Serial.print(wielange); Serial.println("s");
  }
}


// ******************************************************************************
// ********** Schalten in einen festgelegten Zustand ****************************
// ******************************************************************************

void Switch::schalte(int wie) {
  if (rptSwitch) {
    Serial.print("Order: Schalten "); Serial.println(wie);
  }
  if (wie == 0) aus();
  else an();
}


// ******************************************************************************
// ********** Umschalten ********************************************************
// ******************************************************************************

void Switch::toggle() {
  if (state) aus(); else an();
}


// ******************************************************************************
// ********* Schnelle Serviceroutine zur Abschaltung ****************************
// ******************************************************************************

void Switch::check() {
  if (myTimer.abgelaufen()) {
    if (rptSwitch) Serial.println("Timer abgelaufen!");
    aus();
  }
}



// ******************************************************************************
// ********* Schaltzustand abfragen *********************************************
// ******************************************************************************

boolean Switch::istAn(){
  return state;
}


// ******************************************************************************
// ********* Schaltzustand über Timer abfragen **********************************
// ******************************************************************************

boolean Switch::istZeitAn(){
  return myTimer.running();
}



// ******************************************************************************
// ***************** Einen I2C-Port beschreiben *********************************
// ******************************************************************************

void Switch::toIC(int lPortAdr, int daten) {
  if (rptSwitch) {
    Serial.print("Schreibe in I2C-Port: "); Serial.print(lPortAdr);
    Serial.print(" den Wert:"); Serial.println(daten, BIN);
  }
  Wire.beginTransmission(lPortAdr); Wire.write(daten); Wire.endTransmission();
}




