#ifndef Switch_h
#define Switch_h
//#include <ESP.h>
#include <arduino.h>
#include <Wire.h>
#include <timerGru.h>
// ************ Header, muss ausgelagert werden *************************************

class Switch {
  public:
    int setup(int pPort);
    int setup(int pPort, int* pPortInhalt, int pBit);
    void check();                                                                     // Serviceroutine Hauptschleife
    void schalte(int wie);                                                            // Schaltzustand
    void aus();
    void an();
    void an(int wielange);                                                              // Zeituhr
    void toggle();
    void setReport(boolean art);
    boolean istAn();
    boolean istZeitAn();

    // ******************************************************************************
    // ******* Festlegungen für das Modul *******************************************
    // ******************************************************************************
  private:

#define direktS 1                                                                     // Modus
#define I2CM 2                                                                        // Modus    
   
 void toIC(int lPortAdr, int daten);
    // Lokale Platzauser des Objekts
    boolean rptSwitch = false;                                                       // Gesprächiger Modus
    boolean state = false;
    int lPortAdr;                                                                    // Adresse des Steuerports
    int* lPortInhalt;                                                                // Inhalt des Ports bei I2C
    byte lBit;                                                                       // Bitnummer im Port bei I2C
    int modus = 0;                                                                   // Modus: direkt oder I2C
    timerGru myTimer;
};
#endif
