/*********************************
   Einfacher Zeitgeber 
   Version 2025
 *********************************/

#include <timer2Gru.h>


// *************** Implementation ******************


void timer2Gru::setzeLaufzeit(float d) {  // Wird in Sekunden angegeben
  dauer = 1000 * d;
}


void timer2Gru::start() {             // Letzte Dauer wird benutzt
  startZeit = millis();
  state = laeuft;
}


void timer2Gru::start(float dauer) {  // Übergebene Dauer wird verwendet
  setzeLaufzeit(dauer);               // Wert wir auch gemerkt
  startZeit = millis();
  state = laeuft;
}


void timer2Gru::stopp() {
  state = ruht;
}


boolean timer2Gru::abgelaufenV() {  // Läuft, aber Laufzeit ist vorbei
  if ((state == ruht)               // Nicht gestartet, läuft nicht
     || (aktiv())) return false;    // Zeit noch nicht abgelaufen
    state = fertig;   		    // laeuft -> fertig Laufzeit ist vorbei
    return true;
}


boolean timer2Gru::running() {      // Timer gestartet, noch nicht abgelaufen
  if ((state == ruht)               // Timer nicht gestartet
      || (!aktiv()))                // Laufzeit ist schon erreicht
    return false;                   // D.h. Timer läuft noch
  return true;                      // Timer ruht oder ist abgelaufen
}


boolean timer2Gru::abgelaufen() {    // Wenn abgelaufen einmal true melden
  if (!abgelaufenV()) return false;  // Timer ist noch aktiv
  state = ruht;                      // ferig -> ruht, Ende Timernutzung
  return true;                       // Abgelaufen ist er damit
}