/*********************************
   Einfache Zeitgeber ***********
   Version 2020
 *********************************/

#include <timerGru.h>

// *************** Implementation ******************

void timerGru::setzeLaufzeit(float d) {                // Wird in Sekunden angegeben
  dauer = 1000 * d;
}

void timerGru::start() {
  startZeit =  millis();
  waiting = true;
}


void timerGru::start(float dauer) {
  setzeLaufzeit(dauer);
  startZeit =  millis();
  waiting = true;
}


void timerGru::stopp() {
  waiting = false; 
}


boolean timerGru::abgelaufen() {                       // Liefert einmal true, wenn abgelaufen
  if (((millis() - startZeit) > dauer) && (waiting)) {
    waiting = false;
    return true;
  }
  else  return false;
}


boolean timerGru::abgelaufenV() {                      // Liefert immer wieder true, falls abgelaufen
  if (((millis() - startZeit) > dauer)) {
    waiting = false;
    return true;
  }
  else  return false;
}


boolean timerGru::running(){
  return ((millis() - startZeit) <= dauer);
}
