// ********************************************************
// *** Verwaltung der Voreinstellungen ********************
// *** Definition der Bezeichner, Bereitstellung der Werte
// *** Sicherrung der Werte IM Flashspeicher **************
// ********************************************************

#include <Ivor10.h>
#include <Svor10.h>
#include <Bvor10.h>

#define rptVor 'V' - '0'
Svor10 sPar;
Ivor10 iPar;  // Integer-Vorgaben
Bvor10 bPar;

// *** Informationen für das WLAN ************************************************************
const byte netzAdr[] = { 192, 168, 178 };  // Netzwerkadresse
const byte gerAdr[] = { 245, 246 };        // Geräteadresse WLAN, ESP
const byte gatewAdr = 1;                   //
String ssid = "Grunewald";                 // WiFi-Informationen
String password = "ganz arg geheim";       //
char* AP_SSID = "SDR";                     //
char* AP_Passwort = "auch geheim";         //

IPAddress local_IP(netzAdr[0], netzAdr[1], netzAdr[2], gerAdr[0]);   // Web-Adresse WLAN
IPAddress local_Lan(netzAdr[0], netzAdr[1], netzAdr[2], gerAdr[1]);  // Web-Adresse LAN, W5500
IPAddress gateway(netzAdr[0], netzAdr[1], netzAdr[2], gatewAdr);     //
IPAddress subnet(255, 255, 255, 0);                                  //
IPAddress primaryDNS(8, 8, 8, 8);                                    // optional, unser Freund Google
IPAddress secondaryDNS(8, 8, 4, 4);                                  // optional

void setupPref() {
  zeigz("Voreinstellungen initialisieren");
  //sPar.killThemAll();        // Das können wir nun über den Reportmodus V
  //iPar.killThemAll();        // Voreinstellungen zurücksetzten
  sPar.setPName("SHzgPrefs");  // Beichner der Daten im Filesystem
  iPar.setPName("IHzgPrefs");  //
  bPar.setPName("BHzgPrefs");  //
  //sPar.setTalk(true);        // Quaselmodus ein-/ausschalten
  //iPar.setTalk(true);        //

  //*** Defaultwerte der Voreinstellungen ***

  if (!iPar.readThem()) {  // Leseversuch ist fehlgeschhlagen, Voreinstellungen setzen und merken
    zeigz("Integer-Parameter defekt oder fehlen, verwende Defaultwerte");
    iPar.setName(iLuftStart, "L&uumlfter Start (&degC)");
    iPar.setMin(iLuftStart, 15);
    iPar.setMax(iLuftStart, 40);
    iPar.setWert(iLuftStart, 25);

    iPar.setName(iLuftMax, "L&uumlfter max. (&degC)");
    iPar.setMin(iLuftMax, 30);
    iPar.setMax(iLuftMax, 70);
    iPar.setWert(iLuftMax, 50);

    iPar.setName(iPANachlauf, "PA-Delay (s)");  // Gemessen in s
    iPar.setMin(iPANachlauf, 0);
    iPar.setMax(iPANachlauf, 300);
    iPar.setWert(iPANachlauf, 2);

    iPar.setName(i28VLimit, "28V-Limit (mV)");
    iPar.setMin(i28VLimit, 24000);
    iPar.setMax(i28VLimit, 28500);
    iPar.setWert(i28VLimit, 28200);

    iPar.setName(i12VLimit, "12V-Limit (mV)");
    iPar.setMin(i12VLimit, 11000);
    iPar.setMax(i12VLimit, 13000);
    iPar.setWert(i12VLimit, 12700);

    iPar.setName(i5VLimit, "5V-Limit (mV)");
    iPar.setMin(i5VLimit, 4500);
    iPar.setMax(i5VLimit, 5500);
    iPar.setWert(i5VLimit, 5100);

    iPar.setName(iVRueckMax, "VRueckMax.  (mV)");
    iPar.setMin(iVRueckMax, 3000);
    iPar.setMax(iVRueckMax, 6000);
    iPar.setWert(iVRueckMax, 5000);

    iPar.setName(iSWRMax, "SWR-Max.");
    iPar.setMin(iSWRMax, 1100);
    iPar.setMax(iSWRMax, 3000);
    iPar.setWert(iSWRMax, 2000);

    iPar.setName(iFrei2, "Frei2");
    iPar.setMin(iFrei2, 5);
    iPar.setMax(iFrei2, 255);
    iPar.setWert(iFrei2, 30);

    iPar.setName(iFrei3, "Frei3");
    iPar.setMin(iFrei3, 0);
    iPar.setMax(iFrei3, 255);
    iPar.setWert(iFrei3, 30);

    zeigz("Schreibe Integer-Deaults als Integer-Parameter");
    iPar.writeThem();  // Neue Voreinstellungen gemerkt
  } else zeigz("Integer-Parameter erfolgreich aus Flash-Speicher gelesen");

  // *** Ebenso geht es bei den Strring-Parametern ***
  if (!sPar.readThem()) {
    zeigz("Stringparameter defekt oder fehlen, verwende  Defaults");

    sPar.setName(sSSID, "SSID");
    sPar.setWert(sSSID, ssid);

    sPar.setName(sPassword, "Passwort");
    sPar.setWert(sPassword, password);

    sPar.setName(sP2, "String2");
    sPar.setWert(sP2, "String2");

    sPar.setName(sP3, "String3");
    sPar.setWert(sP3, "String3");

    sPar.setName(sP4, "String4");
    sPar.setWert(sP4, "String4");

    sPar.setName(sP5, "String5");
    sPar.setWert(sP5, "String5");

    sPar.setName(sP6, "String6");
    sPar.setWert(sP6, "String6");

    sPar.setName(sP7, "String7");
    sPar.setWert(sP7, "String7");

    sPar.setName(sP8, "String8");
    sPar.setWert(sP8, "String8");

    sPar.setName(sP9, "String9");
    sPar.setWert(sP9, "String9");

    zeigz("Schreibe Strimg-Defaults als Parameter");
    sPar.writeThem();
  } else zeigz("Stringparameter aus Flash-Speicher gelesen.");

  // *** Es folgen die boolschen Voreinstellungen
  if (!bPar.readThem()) {
    zeigz("Bool-Parameter defekt oder fehlen, verwende  Defaults");

    bPar.init(bWLan_an, "WLAN an", true);
    bPar.init(bTestU, "Aus bei &Uumlberspannung", true);
    bPar.init(bTestSWR, "Aus SWR-&Uumlberschreitung", true);
    bPar.init(bUsePTT, "PTT schaltet PA-Spannung", true);
    bPar.init(bP4, "frei4", false);
    bPar.init(bP5, "frei5", false);
    bPar.init(bP6, "frei6", false);
    bPar.init(bP7, "frei7", false);
    bPar.init(bP8, "frei8", false);
    bPar.init(bP9, "frei9", false);
    zeigz("Schreibe Bool-Defaults als Parameter");
    bPar.writeThem();
  } else zeigz("Bool-Parameter aus Flash-Speicher gelesen.");
  zeig("Init mit:");
  for (uint8_t b = 0; b < bpZahl; b++) {
    zeig(bPar.getWert(b));
    zeig(" ");
  }
  zeigz();
}


// *** Änderungen im Protokoll vermerken, diese anwenden,
// *** diese sichern. Fas geschieht zum Teil automatisch in den Lbraries

void iParChanged(uint8_t aNr) {
  zeigz((String) "iParChanged mit " + aNr);
  switch (aNr) {
    case iLuftStart:
      dMerken(StN(myTime(), 7) + "; LuftStart; " + String(iPar.getWert(iLuftStart)) + ";" + ";°C");
      break;
    case iLuftMax:
      dMerken(StN(myTime(), 7) + "; LuftMax; " + String(iPar.getWert(iLuftMax)) + ";" + ";°C");
      break;
    case iPANachlauf:
      dMerken(StN(myTime(), 7) + "; Nachl; " + String(iPar.getWert(iPANachlauf)) + ";" + ";s");
      break;
    case i28VLimit:
      dMerken(StN(myTime(), 7) + "; Lim28; " + String(iPar.getWert(i28VLimit)) + ";" + ";mV");
      break;
    case i5VLimit:
      dMerken(StN(myTime(), 7) + "; lim5; " + String(iPar.getWert(i5VLimit)) + ";" + ";mV");
      break;
    case i12VLimit:
      dMerken(StN(myTime(), 7) + "; lim12; " + String(iPar.getWert(i12VLimit)) + ";" + ";mV");
      break;
    case iVRueckMax:
      dMerken(StN(myTime(), 7) + "; RueckMax; " + String(iPar.getWert(iVRueckMax)) + ";" + ";mV");
      break;
    case iSWRMax:
      dMerken(StN(myTime(), 7) + "; swrMax; " + String(iPar.getWert(iSWRMax)) + ";" + ";-");
      break;
    case iFrei2:
      dMerken(StN(myTime(), 7) + "; Frei2; " + String(iPar.getWert(iFrei2)) + ";" + ";s");
      break;
    case iFrei3:
      dMerken(StN(myTime(), 7) + "; frei3; " + String(iPar.getWert(iFrei3)) + ";" + ";#");
      break;
  }
}

// *** SParameter geändert, Änderungen anwenden ***

void sParChanged(uint8_t aNr) {  // Hier noch nicht verwendet
  zeigz((String) "sParChanged mit " + aNr);
  switch (aNr) {
    case sSSID: break;      // Keine weitere Aktion nötig
    case sPassword: break;  // Keine Aktion nötig
    case sP2: break;        //
    case sP3: break;        //
    case sP4: break;        //
    case sP5: break;        //
    case sP6: break;        //
    case sP7: break;        //
    case sP8: break;        //
    case sP9: break;        //
  }
}

// *** bParameter geändert, Änderungen anwenden ***

void bParChanged(uint8_t aNr) {
  zeigz((String) "pParChanged mit " + aNr);
  switch (aNr) {
    case bWLan_an: break;  // Keine weitere Aktion nötig
    case bTestU: break;    // Keine Aktion nötig
    case bTestSWR: break;  //
    case sP3: break;       //
    case bP4: break;       //
    case bP5: break;       //
    case bP6: break;       //
    case bP7: break;       //
    case bP8: break;       //
    case bP9: break;       //
  }
}

// *** String prüfen, hier nur Primitivversion

bool sCheck(int aNR, String* s) {
  String k = *s;
  int f = k.indexOf("+");
  /*
  zeig(aNr);
  zeig("  ");
  zeigz(*s);
  */
  if (f < 0) {
    return true;
  } else {
    zeigz("Verbotenes Leerzeichen, Eingabe verworfen!");
    return false;
  }
}
