// ********************************************************
// *** Portmanager, gibt Befehle auf die Ausgangports aus *
// *** Kontrolliert hier die Netzschaltung und PA-Spannung
// *** Kontrolliert die LNB.Versorgung und den PTT-Port ***
// *** Version 05.03.25 ***********************************
// ********************************************************

// Zuordnung der Funktionen zu den ESP-Ports

#define re1P 25
#define re2P 32
#define uHP 15
#define uVP 2


// Indices für die Ausgänge vergeben
#define rNetz 0                         // Hauptnetzteil schalten
#define rPAOn 1                         // PA schalten
#define uH 2                            //
#define uV 3                            //
uint8_t sIndexWert[] = { 1, 2, 4, 8 };  // Bit 0..31 für Outputzustandspeicher

#define on true
#define off false

// #define anzOutput 4  // Ausgänge, vorgezogen

#define rptPort 3                           //
#define messL 30                            // Länge eines Datentelegramms
#define in1 5                               // PTT Rückmeldung
uint8_t sAdr[] = { re1P, re2P, uHP, uVP };  //
bool ptt;                                   // Merkregister für Input-Ports
timer2Gru startdelay;                       // Einige Funktionen beim Start abschalten
String sdrError;                            // Fehlermeldung

// *********************************************************
// ***  Konstanten für LNB *********************************
// *********************************************************

#define lnbFStepZahl 3                                    // 3 Schrittweiten möglich
#define lnbModeZahl 3                                     // 3 Betriebsarten
enum LnbState { OFF,                                      // Mögliche LNB-Zustände
                HOR,                                      //
                VERT };                                   //
String lnbMStr[] = { " Aus", "Horizontal", "Vertikal" };  //
enum LnbFreq { EINS,                                      // Mögliche Schrittweiten
               VIER,                                      //
               ZEHN };                                    //
String lnbFStr[] = { "Eins", "Vier", "Zehn" };            //
LnbState lnbM = VERT;                                     // Polarisation setzen
LnbFreq lnbF = EINS;                                      // Schrittweite setzen


// ********************************************************
// *** Vorbereitung des Portmanagers **********************
// ********************************************************

void setupPorts() {                      // Ports initialisieren
  for (int i = 0; i < anzOutput; i++) {  // Wir zählen hier ab Null!
    output[i].setup(sAdr[i]);            // Outputausgänge den Ports zuordnen
    output[i].aus();                     // Schalter betätigen
    output[i].setReport(false);          // Schweigsamer Modus als Default
  }                                      //
  setupFan();                            //
  setupLNB();                            //
  setupIn();                             //
  startdelay.start(10);                  // PA-Sperre bis Pluto läuft
  zeigz("Portmanager initialisiert!");   //
}


// *********************************************************
// Periodisch aus der Hauptschleife aufgerufen
// *********************************************************

void checkPorts() {
  for (int i = 0; i < anzOutput; i++)  // Wir zählen hier ab Null!
    output[i].check();                 // Serviceroutine für Output
}


// *********************************************************
//***************** Outputsteuerung ************************
// ****** Einen Output einschalten, Index 0 .. 3 ***********
// *********************************************************

void ein(int nr) {
  if ((nr >= 0) && (nr < anzOutput)) {  // Gültige Nummer
    ///zeig(nr), zeig(" ");
    output[nr].an();                                      // Schalter: Ein!
    dMerken(StN(myTime(), 7) + ";Output;" + nr + ";An");  // Archiveintrag vornehmen
    if (report == rptPort)                                //
      zeigz("Output: " + String(nr) + " Ein!");           // Meldung
  } else                                                  //
    zeigz("Einschalten: Outputindex out of range.");      // Fehler
}


// *********************************************************
//***************** Outputsteuerung ************************
// *** Einen Outputkreis  zeitbegrenzt einschalten *********
// *********************************************************

void ein(int nr, int zeit) {
  if ((nr >= 0) && (nr < anzOutput)) {                                              // Gültige Outputnummer
    output[nr].an(zeit);                                                            // Schalter: Ein für angegbene Zeit!                                                              //
    dMerken(StN(myTime(), 7) + ";Output;" + nr + ";An");                            // Archiveintrag
    if (report == rptPort)                                                          // Meldung
      zeigz("Outputnummer: " + String(nr) + " ein für " + String(zeit) + " Min.");  // Wir messen in Sekunden
  } else                                                                            //
    zeigz("Einschalten für eine Zeitspanne: Outputindex out of range.");            // Fehler
}

// *********************************************************
//***************** Outputsteuerung ************************
// *** Alle Gruppen einschalten ****************************
// *********************************************************

void ein() {
  if (report == rptPort)
    zeigz("Ein: Alle!");                               // Meldung
  for (int i = 0; i < anzOutput; i++) output[i].an();  // Alle einschalten
}


// *********************************************************
// *** Einzelnen Output ausschalten, ***********************
// *** wir zählen von 0 bis 3! *****************************
// *********************************************************

void aus(int nr) {
  if ((nr >= 0) && (nr < anzOutput)) {                     // Gültige Outputnummer
    output[nr].aus();                                      // Schalter:; Aus!
    dMerken(StN(myTime(), 7) + ";Output;" + nr + ";Aus");  // Archiveintrag
    if (report == rptPort)                                 // Meldung
      zeigz("Output: " + String(nr) + " Aus!");            //
  } else                                                   //
    zeigz("Outputindex out of range.");                    // Fehler
}


// *********************************************************
//**************** Outputsteuerung *************************
// ******** Alle Ausgänge ausschalten **********************
// *********************************************************

void aus() {
  // zeigz("Befehl: Alle aus");
  if (report == rptPort)
    zeigz("Aus: Alle!");                       // Meldung
  for (int i = 0; i < anzOutput; i++) aus(i);  // Alle ausschalten
}


// *********************************************************
// ***  Output toggeln *************************************
// *********************************************************

void wechseln(int nr) {                       // Wir zählen von 0 bis 3
  if ((nr < 0) || (nr >= anzOutput)) return;  // Verbotene Outputnummer, Ende
  if (output[nr].istAn()) aus(nr);            // Toggeln
  else ein(nr);
}


// *********************************************************
// ***  PWM für Lüfter *************************************
// *********************************************************

#define pwmPin 33     // Port
#define pwmFreq 1000  // pwm - Frequenz
#define pwmRes 8      // Wortlänge für Auflösung, 8 Bit

int speed = 0;            // Aktuelle Drehzahl, 0..100
float pwmSteigung = 1;    // Steigung, Dummy
float temperatur = 20.0;  // Aktuelle Temperatur, Startwert

// *********************************************************
// ***  Initialisierung Lüfter *****************************
// *********************************************************

void setupFan() {                                                           // pwm initialisieren
  pwmSteigung = 100 / (iPar.getWert(iLuftMax) - iPar.getWert(iLuftStart));  //
  temperatur = ds.getTempC();                                               // Aktuelle Temperatur, Startwert
  ledcAttach(pwmPin, pwmFreq, pwmRes);                                      //
  ledcWrite(pwmPin, 0);                                                     //
  zeigz("PWM initialisiert");
}

// *********************************************************
// *** Lüfterdrehzal setzen ********************************
// *********************************************************

void setSpeed(int s) {                                                  // aktuelle Geschwindigkeit ausgeben
  if (s < 0) s = 0;                                                     // Grenzen überprüfen
  if (s > 100) s = 100;                                                 //
  if (report == rptPort) zeigz("Temperatur: " + String(temperatur)      //
                               + " °C, Fanspeed:" + String(s) + " %");  //
  ledcWrite(pwmPin, s * 255 / 100);                                     // Auf PWM-Wertebereich normieren
}


// *********************************************************
// *** Lüfterdrehzahl ermitteln und ausgeben ***************
// *********************************************************

void checkFan() {  // Serviceroutine Lüfter
  temperatur = ds.getTempC();
  if (temperatur >= iPar.getWert(iLuftStart)) {                          // Lüfter benötigt?
    float wert = (temperatur - iPar.getWert(iLuftStart)) * pwmSteigung;  // Sollwert ermitteln
    if (wert < 10) wert = 10;                                            // Minimaldrehzahl erzwingen
    speed = round(wert);                                                 // Typwandlung
  } else speed = 0;                                                      // lüfter darf ruhen, abschalten
  setSpeed(speed);                                                       // Wert ausgeben
}


// *********************************************************
// ***  LNB - Ports initalisieren **************************
// *********************************************************

void setupLNB() {                                  // Beide Ports initialisieren
  aus(uH);                                         //
  aus(uV);                                         //
  zeig("uH=" + String(uH) + " uV=" + String(uV));  //
}


// *********************************************************
// ***  LNB-Ports setzen über Daten des WEB-Interface ******
// *********************************************************

void setLNB(int wie) {        // Port, bei Bedarf setzen
zeig(" LNB auf: ");zeig( wie);///
  if (wie == OFF) {           // aus, keine LNB-Spannung
    aus(uV);                  //
    aus(uH);                  //
    lnbM = OFF;               //
  } else                      //
    if (wie == VERT) {        // Vert-Mode
      aus(uH);                // Hor abschalten
      ein(uV);                // Vert-Spannung anlegen
      lnbM = VERT;            //
    } else if (wie == HOR) {  // HOR-Mode
      ein(uH);                // Hor-Spannung anlegen
      aus(uV);                // Vert auf 0
      lnbM = HOR;             //
    }
  if (report == rptPort) {
    zeig("LNB-Staus: ");
    zeigz(wie);
  }
}



// ********************************************************
// *** Vorbereitung des In-Portmanagers *******************
// ********************************************************

void setupIn() {
  pinMode(in1, INPUT);      // Mode setzen
  digitalWrite(in1, HIGH);  // Pullups aktivieren
}


// ********************************************************
// *** Status des In-Ports lesen **************************
// ********************************************************

void liesPTT() {
  ptt = !(digitalRead(in1) == HIGH);  // PTT is aktiv LOW
}


// *********************************************************
// ********* Farbnummer x:\DVOutput\6_WDR HD Duisburg_LegendÃ¤r - Unsere Hits der 80er!_Aug 09 20;13_93m_132124eines Knopfs feststellen ***********
// *********************************************************

int btFarbe(byte s, byte z) {
  // zeigz("Call mit s=" + String(s) + " z="   + String(z));
  if ((z < 0) || (z >= lineNum)               //
      || (s < 0) || (s >= colNum)) return 0;  // Verbotene Zeilen- oder Spaltennummer
  if (z > 1) return 0;                        // Nur Zeile 1 und Zeile 2 färben
  switch (s) {                                //
    case 0:                                   //
      if (output[z].istAn()) return 1;        //
      else return 0;                          //
      break;                                  //
    case 1: return 0; break;                  // Brauchen wir nicht
    default: return 0;
  }
}


// ********************************************************
// *** Aus Web-Daten Befehl erzeugen **********************
// ********************************************************

void useButtonData(char art, char nr, char was) {   // Wir haben nur Knöpfe zu beachten
  if (report == rptPort) {                          //
    zeigz("Endgültige Auswertung der WEB-Daten!");  //
    zeig("Dispatch: Art=" + String(art));           //
    zeig(" Nr.=" + String(nr));                     //
    zeigz(" Was=" + String(was));                   //
  }                                                 //
  if ((art == 'D') && (nr == '2')) {                // Letzte Tabellenzeile D
    aus(rPAOn);                                     // Alles abschalten
    setLNB(OFF);                                    // LNB-Spannung und Anzeige
    aus(rNetz);                                     // Netzteil 
  }                                                 //
  if (nr == '1')                                    // Erste Spalte der Knopfmatrix
    switch (art) {                                  //
      case 'A':                                     //
        ein(rNetz);                                 // Erste Zeile, Gerät einschalten
        startdelay.start(10);                       // Nach Gerätestart PA und PTT kurz blockieren
        break;                                      //
      case 'B':                                     // Zweite Zeile
        if (!startdelay.running()) {                // Wenn keine Sperre vorliegt
          ein(rPAOn);                               // Einschalten
          sdrError = "";                            // Fehlerspeicher löschen
        }                                           //
        break;                                      //
      case 'C':                                     // Dritte Zeile
        handlePlus();                               //
        break;                                      //
      case 'D':                                     //
        handleSave();                               //
        break;                                      //
      default:;                                     //
    }                                               //
  if (nr == '2')                                    // Knopf aus zweiter Spalte
    switch (art) {                                  //
      case 'A':                                     //
        setLNB(OFF);                                // LNB aus
        aus(rPAOn);                                 // PA aus
        aus(rNetz);                                 // Sonderfall: Gerät abschalten
        break;                                      //
      case 'B':                                     //
        aus(rPAOn);                                 //
        break;                                      //
      case 'C':                                     //
        handleSave();                               //
        break;                                      //
      case 'D':                                     //
        break;                                      //
      default:;                                     //
    }
}
