// *** Einfache Behandlung der Sensoren ******************
// *** ADS1115, 4 Kanal AD-Wanddler DS1820 Thermometer ***
// *** Tasten auslesen ***********************************


#define rptSensor '8' - '0'

float fwv, bwv, u5v, u28v, swr;  // Spannungswerte, swr


//*** ADS 1115 beginnt *********************************

#include "ADS1X15.h"

ADS1115 ADS(0x48);
timer2Gru displayPause;


void setupADS() {
  zeigz(__FILE__);
  zeig("ADS1X15_LIB_VERSION: ");
  zeigz(ADS1X15_LIB_VERSION);
  Wire.begin();
  ADS.begin();// Beim Testbetrieb ausblenden
  displayPause.start(5);
}


void checkADS() {
  if (output[rNetz].istAn()) {  // SDR ist an
    float f;
    ADS.setGain(0);                                                         // Messbereich setzen
    f = ADS.toVoltage(1);                                                   // Voltage Factor lesen
    u28v = ADS.readADC(0);                                                  // Messwerte holen
    u5v = ADS.readADC(1);                                                   //
    bwv = ADS.readADC(2);                                                   //
    fwv = ADS.readADC(3);                                                   //
    fwv = fwv * f;                                                          // Messwerte umrechnen
    bwv = bwv * f;                                                          //
    u5v = u5v * f;                                                          //
    u28v = u28v * f * 10.12;                                                //
    if (fwv > 0.1) swr = (fwv + bwv) / (fwv - bwv);                         // SWR berechnen wenn Output vorhanden
    else swr = 1;                                                           // Geringer Output,SWR = 1
    if ((report == rptSensor) && displayPause.abgelaufen()) {               // Meldung
      zeigz("Werte: ");                                                     //
      zeigz("Vorwärts: " + String(fwv) + " Rückwärts: " + String(bwv)       // Ausgabe
            + " 5V-Quelle:" + String(u5v) + " 28V Quelle: " + String(u28v)  //
            + "SWR:" + String(swr));                                        //
      displayPause.start(5);                                                //
    }                                                                       // Ende Meldung
  }                                                                         // SDRist an
  else {                                                                    // SDR ist ausgeschaqltet
    bwv = 0;                                                                // Eventuellen Offset ausblenden
    fwv = 0;                                                                //
    u28v = 0;                                                               //
    u5v = 0;                                                                // Rückspannung aus Standbynetzteil ausblenden
    swr = 0;                                                                // SWR ist so nicht vorhanden
  }                                                                         // Ende SDR ist aus}
}

// ********************************************************
// *** Nun der DS 18B20 ************************************
// ********************************************************

/*
#include <DS18B20.h>
#define DS1820Pin 4
DS18B20 ds(DS1820Pin);
*/

// ********************************************************
// *** Initialisierung des Thermometers *******************
// ********************************************************

void setup1820() {
  while (ds.selectNext()) {
    // ds.setAlarms(LOW_ALARM, HIGH_ALARM);
  }
}


// ********************************************************
// *** Temperaturmessung ********************************
// ********************************************************

void check1820() {
  ds.doConversion();
  if (report == rptSensor) {
    zeig("Temperatur: ");
    zeig(ds.getTempC());
    zeigz(" C\n");
  }
}


// ********************************************************
// *** Tastatur *******************************************
// ********************************************************

#define tPlus 36   // Port der Tasten
#define tMinus 34  //
#define tSave 35   //
#define RXD2 16    // Port der Pins
#define TXD2 17    // der zweiten seriellen Schnittstelle

boolean sPlus, sMinus, sSave, lPlus, lMinus, lSave;

// ********************************************************
// *** Tastatur initialisieren ****************************
// ********************************************************

void setupTasten() {
  Serial2.begin(9600, SERIAL_8N1, RXD2, TXD2);  // Schnittstelle vorbereiten
  pinMode(tPlus, INPUT);                        //
  lPlus = state(tPlus);
  pinMode(tMinus, INPUT);
  lMinus = state(tMinus);
  pinMode(tSave, INPUT);
  lSave = state(tSave);
}


// ********************************************************
// *** Auf Tastendruck reagieren * *************************
// ********************************************************

void lnbOut(uint8_t l) {  // Schreibt in den LNB
  // Erlaubt sind: W,S,X; inc; Q,A,Z: dec U:save
  if ((l < 0) || (l > 6)) {
    zeigz("Ungültiger LNB-Befehl");
    return;
  }
  char legalB[] = { 'W', 'S', 'X', 'Q', 'A', 'Z', 'U' };   // Die sind erlaubt
  if (report == rptSensor) zeigz("An LNB: " + legalB[l]);  // Meldung
  Serial2.print(legalB[l]);                                // Ausgabe an LNB
  // zeigz(legalB[l]);
}

void handlePlus() {
  if (report == rptSensor) zeigz("Plustaste gedrückt");
  lnbOut(lnbF);
}

void handleMinus() {
  if (report == rptSensor) zeigz("Minustaste gedrückt");
  lnbOut(lnbF + 3);
}

void handleSave() {
  if (report == rptSensor) zeigz("Savetaste gedrückt");
  lnbOut(6);
}


// ********************************************************
// *** Tastatur auslesen ****************************
// ********************************************************

void checkTasten() {
  sPlus = state(tPlus);  // Port lesen
  //zeig("Plus:");zeig(sPlus);
  if (sPlus != lPlus) {        // Tastenzustand verändert
    lPlus = sPlus;             // Aktuellen Zustand merken
    if (!sPlus) handlePlus();  // Ruhepegl ist HIGH, reagiere auf KeyDown
  }                            //
  sMinus = state(tMinus);      // Ebenso
  //zeig("Minus:");zeig(sMinus);
  if (sMinus != lMinus) {        //
    lMinus = sMinus;             //
    if (!sMinus) handleMinus();  //
  }                              //
  sSave = state(tSave);          // Hier ebenso
  //zeig("Save:"); zeigz(sSave);
  if (sSave != lSave) {        //
    lSave = sSave;             //
    if (!sSave) handleSave();  //
  }
}


// ********************************************************
// *** Anzeige der Messwerte ******************************
// ********************************************************

void showSensors() {
  zeigz(ds.getTempC());
  zeigz(ADSText());
  // Ausgabe des Tastenstatus fehlt
}


// ********************************************************
// *** Texte für WEB-Server erzeugen **********************
// ********************************************************

String ADSText() {
 return String("<br>Spannungen: ") + "<br>28V-Quelle:" + String(u28v) + "V" + " 5V-Quelle:" + String(u5v) + "V"
        + String(fwv) + "V" + "<br>SWV: " + String(swr);
}


// ********************************************************
// *** Alle Sensoren Aufsetzen ****************************
// ********************************************************

void setupSensors() {
  setupADS();
  setup1820();
  setupTasten();
}


// ********************************************************
// *** Alle Messwerte ermitteln ***************************
// ********************************************************

void checkSensors() {
  checkADS();     // Eventuell alle 100 ms ausführen
  check1820();    //
  checkTasten();  //
}
