// ********************************************************
// *** Einfacheres NTP-Modul vom 6.10.21 ******************
// ********************************************************

#include "time.h"
#define rptNTP '5' - '0'

const char* ntpServer = "pool.ntp.org";  //"3.pool.ntp.org";  //"pool.ntp.org";
const long gmtOffset_sec = 3600;         // UTC + 1h
const int daylightOffset_sec = 3600;     // Sommerzeitoffset
struct tm systemzeit;                    //
int ntpDay;                              // Merker für Wochentag


// ********************************************************
// *** Initialisierung ************************************
// ********************************************************

void setupNTP() {
  zeigz("NTP-Modul initialisieren.");
  configTime(gmtOffset_sec, daylightOffset_sec, ntpServer);
  delay(100);
  checkNTP();
  ntpDay = day();
  zeig("NTP-Zeit: ");
  digitalClockDisplay();
}


// ********************************************************
// *** Serviceroutine typisch in 10-Minutenabstand ********
// ********************************************************

void checkNTP() {
  if (!getLocalTime(&systemzeit)) {
    zeigz("Zugriff auf NTP-Server gescheitert!");
  }
  if (report == rptNTP) digitalClockDisplay();
}


// ********************************************************
// *** Test auf Tageswechsel seit letzter Abfrage *********
// ********************************************************

boolean tageswechsel() {
  boolean tmp;
  tmp = (ntpDay != day());
  ntpDay = day();
  return tmp;
}


// ********************************************************
// *** Unformatierte Zeitausgabe **************************
// ********************************************************
/*
  void printLocalTime() {
  checkNTP();
  zeig(" Tag:"); zeig(day());
  zeig(" Monat:"); zeig(month());
  zeig("Jahr:"); zeig(year());
  zeig(" Stunde:");  zeig(hour());
  zeig(" Minute:"); zeig(minute());
  zeig(" Sekunde:"); zeigz(second());
  }
*/

// ********************************************************
// *** Interne Zeit bestimmen *****************************
// ********************************************************

unsigned long myTime() {
  return (unsigned long)(weekday() - 1) * 1000000 + hour() * 10000 + minute() * 100 + second();
}


// ********************************************************
// *** Digital Clock, Anzeige der Zeit vom NTP-Server *****
// ********************************************************

void digitalClockDisplay() {
  zeigz(StN(hour(), 2) + ":" + StN(minute(), 2) + ":" + StN(second(), 2)
        + " - " + StN(day(), 2) + "." + StN(month(), 2) + "."
        + String(year()) + " TimeZone:" + String(gmtOffset_sec / 3600));
}


// ********************************************************
// *** Kompatibilität mit altem NTP-Modul herstellen ******
// *** Zeitinformation als Funktion bereitstellen *********
// *** Erspart die Korrektur des bisherigen Codes *********
// ********************************************************

int hour() {
  return systemzeit.tm_hour;
}


int minute() {
  return systemzeit.tm_min;
}


int second() {
  return systemzeit.tm_sec;
}

int day() {
  return systemzeit.tm_mday;
}


int month() {
  return systemzeit.tm_mon + 1;  // System zählt ab 0!
}


int year() {
  return systemzeit.tm_year + 1900;  // System zählt ab 1900
}


int weekday() {
  return systemzeit.tm_wday;
}
