// ********************************************************
// *** Hier sind eigenständige Routinen des Systems *******
// ********************************************************
#define rptAkt 'C'

// ********************************************************
// *** Messe Spannungen Pluto und PA, *********************
// *** Bei Überspannung PA und Pluto abschalten ***********
// ********************************************************

void checkVoltages() {                                                                   // Muss zuerst erfolgen
  if (u28v * 1000 > iPar.getWert(i28VLimit)) {                                           // u28v zu groß
    if (bPar.getWert(bTestU)) aus(rNetz);                                                // SDR ausschalten, wenn erlaubt
    sdrError = "28V-Limit: " + String(iPar.getWert(i28VLimit))                           // Meldung erzeugen
               + "mV Gemessen aber: " + String(u28v * 1000) + "mV, das ist zu hoch!!!";  //
    zeigz(sdrError);                                                                     // Meldung zeigen
  }                                                                                      //
  if (u5v * 1000 > iPar.getWert(i5VLimit)) {                                             // u5v zu groß
    if (bPar.getWert(bTestU)) aus(rNetz);                                                // SDR ausschalten, wenn erlaubt
    sdrError = "5V-Limit: " + String(iPar.getWert(i5VLimit))                             // Meldung erzeugen
               + "mV Gemessen aber: " + String(u5v * 1000) + "mV , das ist zu hoch!!!";  //
    zeigz(sdrError);                                                                     // Meldung zeigen
  }
}


// ********************************************************
// *** check PTT-Taste, schaltet PA-Spannung **************
// ********************************************************

void checkPTT() {                                  // Dann Serviceroutine PTT-Taste
  if (output[rNetz].istAn()) {                     // Nur bei eigeschaltetem SDR
    liesPTT();                                     // PTT-Port lesen
    ;                                              // zeig(ptt); zeig(" ");
    if (ptt)                                       // PTT ist aktiv, Taste gedrückt
      if (bPar.getWert(bUsePTT)) {                 // PTT-Signal nutzen?
        if (!startdelay.running()) {               // PA- und PTT-Sperre nicht aktiv
          ein(rPAOn, iPar.getWert(iPANachlauf));   // PA einschalten mit Nachlaufzeit
          sdrError = "";                           // Fehlerspeicher löschen
        }                                          // Ende: PTT-Signal verwenden
        if (report == rptAkt) zeigz("PTT aktiv");  // Meldung zeigen
      }                                            // Ende: PTT wird genutzt
      else {                                       // PTT-Signal nicht nutzen:
        ;                                          // Dann nichts schalten
      }                                            // Ende: PTT nicht nutzen
    else                                           // PTT ist nicht gedrückt
      swr = 0;                                     // Es gibt kein SWR
  }                                                // Ende: SDR eingeschaltet
}


// ********************************************************
// *** SWR checken, wenn nötig: Abschalten! ***************
// *** Ebenso URück prüfen, wenn zu groß: Abschalten ******
// *** Wenn SDR aus ist: Restspannungen ausblenden ********
// ********************************************************

void checkSWR() {                                                                      // Nun SWR prüfen, wenn nötig ausschalten
  if (output[rNetz].istAn()) {                                                         // SDR ist eingeschaltet
    if (ptt)                                                                           // PTT ist aktiv
      if (swr * 1000 >= iPar.getWert(iSWRMax)) {                                       // SWR zu groß?
        aus(rPAOn);                                                                    // Endstufe abschalten, wenn erlaubt
        sdrError = "SWR Limit: " + String(float(iPar.getWert(iSWRMax) / 1000))         // Meldung
                   + " Gemessen aber SWRk: " + String(bwv) + " zu hoch!!!";            //
        zeigz(sdrError);                                                               //
      }                                                                                // Ende SWR ist zu hoch
    if (bwv * 1000 >= iPar.getWert(iVRueckMax)) {                                      // URück zu groß
      aus(rPAOn);                                                                      // Endstufe abschalten, wenn erlaubt
      sdrError = "URu&umlck Limit: " + String(float(iPar.getWert(iVRueckMax) / 1000))  // Meldung
                 + " Gemessen aber URu&umck: " + String(swr) + " zu hoch!!!";          //
      zeigz(sdrError);                                                                 //
    }                                                                                  // Ende: Urück ist zu groß
  }                                                                                    // Ende SDR eingeschaltet
  else {                                                                               // SDR ist nicht eingeschaltet
    swr = 0;                                                                           // SWR=0
    if (output[rPAOn].istAn()) aus(rPAOn);                                             // PA-Versorgung gegf. abschalten
  }                                                                                    // Ende SDR ist aus, PA nun auch
}
