// *********************************************************
// *** Anbindung an das WiFi, Verbindung herstellen ********
// *** WiFi wird von Core0 gemanaged, Multithreading starten
// *** Reihenfolge STA und AP geändert, geht sicherer ******
// ********************* 08.09.24 **************************
// *********************************************************
#include <WiFi.h>

#define rptWiFi 'B' - '0'

boolean WLANTalk = false;  // Quaselmodus

// *** Hilfsfunktionen *************************************

// *********************************************************
// *** Ist WiFi verbunden? *********************************
// *********************************************************

boolean WiFiOK() {
  return (WiFi.status() == WL_CONNECTED);
}

boolean WiFigeht = false;


// *********************************************************
// *** Reporting *******************************************
// *********************************************************

void checkWLAN() {
  WLANTalk = (report == rptWiFi);
}

// *********************************************************
// *** BEGIN ERROR Handling ********************************
// *********************************************************

boolean WLAN_Error;

void setError() {
  WLAN_Error = true;
  if (WLANTalk) zeigz("Set E");
}

void clearError() {
  WLAN_Error = false;
  if (WLANTalk) zeigz("Res E");
}

boolean getError() {
  if (WLANTalk) zeigz("E ?");
  return WLAN_Error;
}
// *** END Hilfsfunktionen,  ERROR Handling ****************


// *********************************************************
// *** BEGIN FreeRTOS einrichten ***************************
// *********************************************************

TaskHandle_t Core0TaskHnd;
// TaskHandle_t Core1TaskHnd; // Hier nicht benötigt
// *** END   FreeRTOS einrichten ***************************


// *********************************************************
// *** Multthreading starten *******************************
// *********************************************************

void setupWiFi() {
  zeigz("Multithreading starten!");
  xTaskCreatePinnedToCore(CoreTask0, "CPU_0", 10000, NULL, 5, &Core0TaskHnd, 0);
  // xTaskCreatePinnedToCore(CoreTask1, "CPU_1", 10000, NULL, 5, &Core1TaskHnd, 1);
}


// *********************************************************
// *** WiFi-Verbindung herstellen, notfalls mehrfach *******
// *********************************************************

void WLAN_setup() {
  zeigz("Verbindungsversuch zum WiFi:");
  WiFigeht = false;
  uint8_t nr = 1;
  do {
    zeigz("WLAN: Verbindungsversuch " + String(nr));
    do_WLAN_setup();
    nr++;
  } while (!WiFiOK());
  zeigz("Habe WiFi-Verbindung!");
  WiFigeht = true;
}


// *********************************************************
// *** WiFi-Verbindung herstellen **************************
// *********************************************************

void do_WLAN_setup() {                                                    //
  WiFi.disconnect();                                                      //
  unsigned long go = millis();                                            //
  if (!WiFi.config(local_IP, gateway, subnet, primaryDNS, secondaryDNS))  //
    zeigz("STA Failed to configure");                                     //
  //WiFi.mode(WIFI_MODE_APSTA);                                             //
  //WiFi.softAP(AP_SSID, AP_Passwort);                                      //
  WiFi.begin(ssid.c_str(), password.c_str());  //
  Serial.print("Wunschadresse STA:");          //
  zeigz(local_IP);                             //
  zeigz("Verbinde mit WiFi...");               //
  while (WiFi.status() != WL_CONNECTED) {      //
    delay(500);                                //
    if ((millis() - go) > 5000) return;        // Timeout!
  }                                            //
  Serial.print("AP-Modus mit: ");              // Ergebnis mitteilen
  zeigz(WiFi.softAPIP());                      //
  Serial.print("Adresse im WiFi: ");           //
  zeigz(WiFi.localIP());                       //
  Serial.print("Mac Addresse: ");              //
  zeigz(WiFi.macAddress());                    //
  Serial.print("Subnet Maske: ");              //
  zeigz(WiFi.subnetMask());                    //
  Serial.print("Gateway IP: ");                //
  zeigz(WiFi.gatewayIP());                     //
  Serial.print("DNS: ");                       //
  zeigz(WiFi.dnsIP());                         //
  zeigz();                                     //
}


// ********************************************************
// *** Aktivitäten des Core0 ******************************
// ********************************************************

// *** BEGIN Zeitscheiben für Core 0 **********************

void Core_0_Task100ms() {
  // BEGIN *** WLAN Verbindung prüfen ***
  if (WiFi.status() != WL_CONNECTED) setError();
  else clearError();
  // END   *** WLAN Verbindung prüfen ***
}

void Core_0_Task500ms() {
}

void Core_0_Task1000ms() {
  if (WLANTalk) zeigz("Core0  1s");                    //
  const int8_t iWLAN_TimeOut_Max = 4;                  // Timeout nach 4s
  static int8_t iWLAN_TimeOut = iWLAN_TimeOut_Max;     //
  static int8_t iWLAN_ReConnect = 0;                   //
  if (getError()) iWLAN_TimeOut--;                     // Kein WLAN, Timeout Zähler dekrementieren
  if (!getError()) iWLAN_TimeOut = iWLAN_TimeOut_Max;  // Alles gut, WLAN connected
  if (iWLAN_TimeOut == 0) {                            // Wenn WLAN Timeout erreicht, Reconnect
    zeigz("WLAN neu aufbauen!");                       //
    WLAN_setup();                                      // Nächster Versuch
    iWLAN_ReConnect++;                                 //
    iWLAN_TimeOut = iWLAN_TimeOut_Max;                 //
  }                                                    //
  if (iWLAN_ReConnect > 300) esp_restart();            // Neu booten, zu viele Fehleversuche
}  //

// ----- END   Zeitscheiben für Core 0 -----
// ===== END   - CODE wird nur im Core 0 aufgerufen =====


// ********************************************************
// *** Loop für Arduino/Core 0 und Core 1 *****************
// ********************************************************

void CoreTask0(void* parameter) {
  static uint32_t TimeLastMillis100;                       // Hilfsvariablen Zeitsteuerun
  static uint32_t TimeLastMillis500;                       //
  static uint32_t TimeLastMillis1000;                      // Zeitkonstanten
  const uint32_t TimeBase100 = 100UL;                      //
  const uint32_t TimeBase500 = 500UL;                      //
  const uint32_t TimeBase1000 = 1000UL;                    //
  setError();                                              // Voreinstellung: Keine WiFi vorhanden
  WLAN_setup();                                            // WLAN erstmalig einrichten / aktivieren
  for (;;) {                                               // Ewig! Zeitscheiben erzeugen
    if ((millis() - TimeLastMillis100) > TimeBase100) {    // Alle 100 ms
      TimeLastMillis100 += TimeBase100;                    //
      Core_0_Task100ms();                                  //
    }                                                      //
    if ((millis() - TimeLastMillis500) > TimeBase500) {    // Alle 500 ms, hier nicht benötigt
      TimeLastMillis500 += TimeBase500;                    //
      Core_0_Task500ms();                                  //
    }                                                      //
    if ((millis() - TimeLastMillis1000) > TimeBase1000) {  // Alle 1 s
      TimeLastMillis1000 += TimeBase1000;                  //
      Core_0_Task1000ms();                                 //
    }                                                      //
    vTaskDelay(1);                                         //
  }                                                        //
}

// *** core1 erhält keine weiteren Aufgaben ***
