// ********************************************************
// *** Sammeln der Messwerte und Schaltvorgänge,***********
// *** Einstellen in die Liste, ***************************
// *** Listenversand über Server auf Port 8080 ************
// *** Sparsame Version, vermeidet String-Objekte *********
// *** Version August 2020 ********************************
// ********************************************************

#define maxAnzTel 200                                      // Größe des Ringpuffers
#define telegL messL                                       // Maximallänge eines Telegramms wie Länge derr Message
#define dPort 8080                                         // Port für Datenverindungen 
#define rptDaten 2
#define rptMerk 9
#define dBuffLen 600                                       // Beobachtet: Pufferlänge < 402
#define sePuLen (telegL + 9)                               // Pufferlänge muss noch Satznummer, da ";" und <br> aufbehmen

char store[sePuLen][maxAnzTel + 2];                        // Empfangene Daten, noch nicht weitergereicht
int aktTel;                                                // Anzahl der gespeicherten Telegramme
int startNr;                                               // StartNr für Ausgabe der Sätze
boolean pufferVoll;                                        // Alle Positionen des Puffers sind besetzt
char dCurrentLine [dBuffLen];                              // Aktuelle Zeile des Input
char dIncomming [dBuffLen];                                // Gesamter Input
char sendePuffer[sePuLen];                                 // Puffer fpr einen Datensatz bei Rückmeldung

WiFiServer dServer(dPort);
WiFiClient dClient;

// ********************************************************
// *** Datenmoddul initialisieren *************************
// ********************************************************

void setupData() {
  aktTel = 0;                                              // Aktuelle Schreibposition für neue Sätze
  startNr = 0;                                             // Zunächst beginnen wir die Ausgabe vorne
  pufferVoll = false;                                      // Es sind noch nicht alle Pufferpositionen besetzt
  dServer.begin();                                         // Starten müssen wir ihn auch noch
  zeigz("Datenserver auf Port 8080 gestartet!");
}

// ********************************************************
// *** Serviceschleife, Aufruf aus Hauptschleife **********
// ********************************************************

void checkData() {                                         // Schnelle Schleife für Datenkommunikation
  dClient = dServer.available();                           // Horcht auf eingehend Verbindungen
  if (dClient) {                                           // Es gibt eine Verbindung
 //   switchLed(lDat, HIGH);
    dIncomming[0] = 0;                                     // Noch nichts erhalten
    dCurrentLine[0] = 0;
    if (report == rptMerk )zeigz("Neuer Client!");         // Bekanntgabe
    while (dClient.connected()) {                          // Schleife für bestehnde Verbindung
      if (dClient.available()) {                           // Falls der Client was abzuliefern hat
        char c = dClient.read();                           // Lesen eines Zeiches
        if (report == rptMerk ) Serial.write(c);           // Auf Wunsch: Kontrollausgabe
        int dincl = strlen(dIncomming);                    // Falls es passst: An Merker anhängen
        if (dincl < dBuffLen - 1) {
          dIncomming[dincl] = c;
          dIncomming[dincl + 1] = 0;
        }
        if (c == '\n') {                                   // 2 Leerzeilen inFolge, Ende HTTP-Request, wir antworten
          if (dCurrentLine[0] == 0) {                      // Ist die Zeile leer?
            dClient.println("HTTP/1.1 200 OK");            // Responsecode HTTP Header: HTTP/1.1 200 OK)
            dClient.println("Content-type:text/html");     // Der Client soll wissen, wass er kriegt
            dClient.println();
            dClient.print("Hier ist die Antwort des Webservers auf die Anfrage <br>");// Nun folgt der Content der HTTP Antwort:
            dClient.println();                             // Die HTTP Antwort endet mit einer weiteren Leerzeile:
            break;                                         // Dann steigen wir aus der Schleife aus:
          } else {                                         // Nach "Neue-Zeile" dCurrrentLine löschen:
            dCurrentLine[0] = 0;
          }
        } else if (c != '\r') {                            // Falls Zeichen kein CR ist
          //          dCurrentLine += c;
          int dcll = strlen(dCurrentLine);
          if (dcll < dBuffLen - 1 ) {                      // Pufferüberlauf verhindern
            dCurrentLine[dcll] = c;                        // An die Zeile anhängen
            dCurrentLine[dcll + 1] = 0;
          }
        }
      }                                                    // Ende  von client-available
    }                                                      // Ende von while
    dVersenden(false);                                     // Über das Web versenden
    dClient.stop();                                        // Verbindung abbauen:
 //   switchLed(lDat, LOW);                                  // Licht aus!
    if (report == rptMerk ) zeigz("Data-Client Disconnected."); // Sagen wir es der Welt
    if (report ==  rptDaten) dVersenden(true);             // Ausssgabe lokal
  }
}

// ********************************************************
// *** Datensatz in den Ringpuffer aufnehmen **************
// ********************************************************

void dMerken(String Msg) {                                 // Information in den Ringpuffer aufnehmen
//void dMerken(char Msg[sePuLen]) {                        // Information in den Ringpuffer aufnehmen
  if (report == rptDaten ) {
    zeig("Merke:");  zeigz(Msg);
  }
  if ( Msg.length() > telegL) return;                      // Telegramm ist zu lang und ungeeignet
  int bstNr;
  for (bstNr = 0; bstNr < Msg.length(); bstNr++) {         // Einen Satz verarbeiten
    store[bstNr][aktTel] = Msg.charAt(bstNr);
    //zeig(Msg.charAt(p));
  }
  store[bstNr][aktTel] = 0;                                // Endekennzeichnen setzen
  aktTel++;                                                // Satzzähler errhöhen
  if (aktTel == maxAnzTel) {                               // Prüfe, ob Puffer voll.  
    aktTel = 0;                                            // Dann wieder vorne anfangen
    pufferVoll = true;                                     // Alle Positionen sind besetzt
  }
}

// ********************************************************
// *** Datenpuffer komplett ausgeben, per WiFi oder lokal *
// ********************************************************

void dVersenden(boolean lokal) {                           // Gibt den Inhalt des Ringpuffers aus, lokal oder WiFi
  sendePuffer[0] = 0;
  if (!pufferVoll) startNr = 0;                            // Start vorne
  else startNr = aktTel;                                   // Wir starten hinter dem letzten Eintrag
  if (lokal) zeigz("Speicher:");
  int anz = aktTel;
  if (pufferVoll) anz = maxAnzTel;
  for (int i = 0; i < anz; i++) {
    int pos = 0;
    int satzNr = (i + startNr) % maxAnzTel;                // Satznummer begrenzen auf 0 bis maxAnzTel
    itoa(satzNr, sendePuffer, 10);                         // Satznummer in leeren Puffer
    int sPL = strlen(sendePuffer);                         // Der Puffer enthält 1 bis 3 Einträge
    sendePuffer[sPL] = ';';                                // Trennzeichen
    sendePuffer[sPL + 1] = 0;                              // Länge anpassen
    while (store[pos][satzNr] != 0) {                      // Satz endet mit 0
      sPL = strlen(sendePuffer);                           // Aktuelle Position im Puffer
      if (sPL < sePuLen - 1) {                             // Haben wir noch Platz?
        sendePuffer[sPL] = store[pos][satzNr];             // Ein Zeichen anhängen
        sendePuffer[sPL + 1] = 0;                          // Sendepuffer abschließen
      }
      pos++;                                               // Zum nächssten Zeichen
    }
    if (lokal) zeigz(sendePuffer);                         // Auf die Schnittstelle lokal ausgeben  
    else {                                                 // Alternativ in das Web
      if (strlen(sendePuffer) < sePuLen - 5)               // Ist noch Platz für <br>?
        strncat(sendePuffer, "<br>", sePuLen - 1);         // <br>  anhängen
      dClient.println(sendePuffer);                        // Einen Satz in daas Web ausgeben
    }
    sendePuffer[0] = 0;                                    // Aufräumen und Abspülen ...
  }
}
