// *********************************************************
// *** Daten für Webinterfaces bereitstellen ***************
// *** Ausgegliederte Funktionalität von WLAS und LANS *****
// *********************************************************

//#define lineNum 5           // Vorgezogen in Header
//#define colNum 2            // Vorgezogen
#define rptin '6' - '0'       //
#define rptWeb '7' - '0'      //
#define bufflen 1000          // Größe des Puffers
char CurrentLine[bufflen];    // Puffer für eingehende Zeichen, beobachtete Maximallänge: 401
char inCommingLine[bufflen];  // Puffer aller eingegangenen Zeichen
const long tOut = 500;        // Timeout in ms für Webserver
bool aBoxChecked = false;     // Merker für Checkboxstaatus bei Verarbeitung
bool boxes[bpZahl];           // Checkboxen für Werteingabeseite
bool noIco = true;            // Flag: Keine Ico-Seite
#define parZahl 35            // parZahl Parameter sind bei GET maximal möglich
;                             // Resultate, die aus dem GET-Request kommen können
String parName[parZahl];      // Name des Paraameters
String parValue[parZahl];     // Parameterert (String)
uint16_t parStatus[parZahl];  // Status des Werts    0 = not set    1 = valid   -1 = not valid
uint16_t inNr = 0;            // Aktueller Parameter beim Parsen
String HostStr;               // Benötigter Teil von inCommingLine
uint16_t page = 1;            // Nr der gerade angezeigten Seite
uint16_t stElNr;              // Nummer desy aktuellen Steuerelementes beim Parsen
bool ico = false;             // Flag für ICO-Mode


// *********************************************************
// *** Clienanzeige,zunächst die Steuerelemente ************
// *** Texte für die Knöpfe ********************************
// *********************************************************

char* btTxt1 = "<td><button name=\"But\" button style=\"color:";  // Teilstrings für die Buttons
char* btTxt2 = "\" value=\"";                                     //
char* btTxt3 = "\" type=\"submit\">";                             //
char* btTxt4 = "</button></td>";                                  //
char zx[120] = "";                                                // Gesamttext eines Buttons
char btCol[][6] = { "green", "red", "blue" };                     // Farbcodes als Text für Buttons
char btValue[3] = { "A1" };                                       // Button-Value, wird später modifiziert
char btSubmit[colNum * lineNum][18] = {
  // Beschriftungen der Buttons
  "SDR-Modul ein",    //
  "SDR-Modul aus",    //
  "PA-Gruppe ein",    //
  "PA-Gruppe aus",    //
  "LNB-Frequenz+",    //
  "LNB-Frequenz-",    //
  "LNB-speichern",    //
  "!! Abschalten !!"  //
};


// *********************************************************
// *** Einen Knopf basteln und ausgeeben *******************
// *********************************************************

void einButton(char* aCol, char* aValue, char* aSubmit, int welche) {                                   // Bedient WLAN und LAN
  String tmp = (String("\
  <td><button name=\"But\" button style=\"color:")                                                      //
                + aCol + "\" value=\"" + aValue + "\" type=\"submit\">" + aSubmit + "</button></td>");  // Gibt Knopf an Client aus
  if (welche == 0) wClient.print(tmp);                                                                  // in das WLAN
  else lanClient.print(tmp);                                                                            // oder das LAN
}


// *********************************************************
// *** eine Zeile mmit Knöpfen generireren una ausgeben ****
// *********************************************************

void eineButtonreihe(byte zeile, int welche) {       // Bedient WLAN und LAN
  if (welche == 0) wClient.print("<tr>");            //
  else lanClient.print("<tr>");                      // Wir beginnen eine Tabellenzeile
  btValue[0] = char(zeile + 'A');                    // Value-String erster Teil, Port
  for (int spalte = 0; spalte < colNum; spalte++) {  //
    btValue[1] = spalte + '1';                       // Rest Value-String setzen, Spalte
    int btMenCol = btFarbe(spalte, zeile);           // Default: Farbe entspricht Portstatus
    if (zeile >= (lineNum - 1)) {                    // Sonderbehandlung der letzten (!) Zeile
      btMenCol = 0;                                  // Default: Deaktiv (grün)
    }                                                //
    einButton(btCol[btMenCol],                       // Farbnr, Text gemäß Tabelle
              btValue,                               // Rückgabewert ist btValue
              btSubmit[spalte + colNum * zeile],     // Beschriftung des Knopfes
              welche);                               //
  };                                                 //
  if (welche == 0) wClient.print("</tr>");           // Ende der Tabellenzeile
  else lanClient.print("</tr>");                     //
}

// *********************************************************
// *** Stellt alle Buttons in der Tabelle dar **************
// *********************************************************

void zeigeAlleButton(int welche) {                 // Bedient WLAN und LAN
  for (int zeile = 0; zeile < lineNum; zeile++) {  //
    eineButtonreihe(zeile, welche);                //
  }
}


// *********************************************************
// *** Hilfsfunktion; Beschriftung der RadioButtons ********
// *********************************************************

String fStepArray[lnbFStepZahl];  // LNB-Frequwnzschrittweite
String modeArray[lnbModeZahl];    // LNB-Betriebsmodus

void makeArray() {                             // Erzeugt ein Feld mit Texten für die Radio-Buttons
  for (int i = 0; i < lnbFStepZahl; i++) {     // Frequenzschrittweite LNB
    if (lnbF == i) fStepArray[i] = "checked";  // Text für Rad.Button-Code
    else fStepArray[i] = "";                   // Nicht checked
  }                                            //
  for (int i = 0; i < lnbModeZahl; i++) {      // LNB-Betriebszustand
    if (lnbM == i) modeArray[i] = "checked";
    else modeArray[i] = "";
  }
}

// *********************************************************
// *** Systemstatus in einer Tabelle ausgeben **************
// *********************************************************

// Erste Spalte: Ausgänge, zweite Spalte Werte dazu, 3 Spalte ADC Text, 4 Spalte ADC-Wert

String systemState() {

  String tempstr[anzOutput];

  for (int nr = 0; nr < anzOutput; nr++) {         // Der Webserver zählt ab 0!
    if (output[nr].istAn()) tempstr[nr] = " An!";  // Schaltzustand ermitteln
    else tempstr[nr] = " Aus!";
  }
  return " \  
  <table>\
    <tr>\
      <th>Ausg&aumlnge</<th>\
      <th>Zustand</th>\
      <th>ADC-Werte</th>\
       <th>in V</th>\
    </tr>\
    <tr>\
      <td>Netzteil</td>\
      <td>"
         + tempstr[0] + "</td>\
      <td>28 V-Versorgung</td>\
      <td>"
         + String(u28v) + "</td>\
     </tr>\
     <tr>\
       <td>PA-Spannung</td>\
       <td>"
         + tempstr[1] + "</td>\
       <td> 5 V-Versorgung</td>\
       <td>"
         + String(u5v) + "</td>\
     </tr>\
     <tr>\
       <td>LNB 19 V</td>\
       <td>"
         + tempstr[2] + "</td>\
       <td>Vorlauf</td>\
       <td>"
         + String(fwv) + "</td>\
     </tr>\
     <tr>\
       <td>LNB 12 V</td>\
       <td>"
         + tempstr[3] + "</td>\
       <td>R&uumlcklauf</td>\
       <td>"
         + String(bwv) + "</td>\
     </tr>\
         <tr>\
       <td>L&uumlfter</td>\
       <td>"
         + String(speed) + " %" + "</td>\
       <td>Temperatur</td>\
       <td>"
         + String(temperatur) + " &degC" + "</td>\
     </tr>\
     </tr>\
         <tr>\
       <td>SWR</td>\
       <td>"
         + String(swr) + "</td>\
       <td>unbenutzt</td>\
       <td>"
         + String(0) + "</td>\
     </tr>\
  </table>\
    "
         + "<br>" + sdrError + "<br>";  // Fehlermeldung, kann leer sein
}


// ********************************************************
// *** Parameterwerte des Interface auf Nullwerte setzen **
// ********************************************************

void parReset() {                      //
  for (int i = 0; i < parZahl; i++) {  // Bei allen Paraametern
    parName[i] = "";                   // 3 Komponenten...
    parValue[i] = "";                  // .. mit Nullwerten ...
    parStatus[i] = 0;                  // ... initialisieren
  }
}


// *********************************************************
// *** Doppelte Leerzeichen aus String entfernen ***********
// *********************************************************

String killBlanks(String tempStr) {
  String tempStr2 = "";                                              // String ohne Doppelleerzeichen
  if (!tempStr.length() == 0)                                        // Keine Leerstringsverarbeiten
    for (int i = 0; i < tempStr.length() - 1; i++)                   // Alle Zeichen bearbeiten
      if (tempStr.charAt(i) == ' ' && tempStr.charAt(i + 1) == ' ')  // Sind da 2 Blanks in Folge?
        continue;                                                    // Aktuelles Zeicchen auslassen
      else tempStr2 += String(tempStr.charAt(i));                    // Sonst Zeichen übenrnehme
  if (tempStr.charAt(tempStr.length()) != ' ')                       // Letztes Zeichen extra behandeln
    tempStr2 += String(tempStr.charAt(tempStr.length()));            // Auch noch anhängen
  return tempStr2;                                                   // Rückgabeobjekt
}



// *********************************************************
// *** Seite 2, Einstellungen festlegen ********************
// *** String des Einstellungsfensters erzeugen ************
// *********************************************************

String pFStrt() {
  String tempStr, checked;  // Zunächst die Parameter, dann die Buttons für den Rückweg
  tempStr = "<br>\
  <form>\<br>\
<table id=\"Eingabe\">\
  <thead>\
    <tr>\
      <th>Parameter</th>\
      <th>Wert</th>\
  </thead>\
  <tbody>\
    <tr>";
  for (int k = 0; k < ipZahl; k++) {
    if (bPar.getWert(k)) checked = "checked";
    else checked = "";
    tempStr = tempStr + "\
    <tr>\
    <td>" + iPar.getName(k)
              + "</td>\
    <td> : <input type=\"text\" style=\"width:40px\" name=\"iwert"
              + String(k) + "\"maxlength =\"10\" value=" + String(iPar.getWert(k)) + "></td>\
    <td>" + sPar.getName(k)
              + "</td>\
    <td>\ : <input type=\"text\" style=\"width:160px\" name=\"swert"
              + String(k + ipZahl) + "\"maxlength=\"25\" value=" + String(sPar.getWert(k)) + "><br></td>\
    <td>\ :  <input type=\"checkbox\" name=bwert"
              + String(k + ipZahl + spZahl) + " value=1 " + checked + ">" + bPar.getName(k) + "<br> </td>\ 
    </tr>";
  }
  tempStr = tempStr + "\
  </tbody>\
</table>\
  <button name=\"But\" button style=\"color:blue\" value=\"Z2\" type=\"submit\">&Uumlbernehmen</button> \
  <button name=\"But\" button style=\"color:blue\" value=\"Z3\" type=\"submit\">Zur&uumlck</button> \
  </form>\
  ";
  return tempStr;
}


// *******************************************************
// *** Seitenkopf frt Ausgabe generieren *****************
// *******************************************************

String response1(int welche) {                                                       // Erstellt Response-String des Seitenkopfes
  String tempStr = "";                                                               //
  tempStr = String("HTTP/1.1 200 OK") + "/\n" + "Content-type:text/html" + "\n\n";   // Eröffnungsstring
  if (ico) {                                                                         // Icon wurde gefordert, nichts weiter tun
    tempStr += ("<meta http-equiv=\"refresh\" content=\"0; URL=http://192.168.178."  // Sofortiger Refresh
                + String(gerAdr[welche]) + "\"/>");                                  // mit dieser Adrese
    tempStr += ("\n");                                                               // Dann folgt eine Leerzeile
    noIco = false;                                                                   // Ende des Ico-Mode
    ico = false;                                                                     //                                                        //
    return (tempStr);                                                                // Nach ico-Mode nichts abliefern
  } else {                                                                           // Wir waren nicht im ico-Mode, Seitenkopf der Ausgabe hinzufügen
    tempStr += "<!DOCTYPE html>\
  <html>\ 
<body>\
   <center><hl>Gruni Software-Chaos zeigt:</hl></center> \
    <center><h2>Das SDR-Radio f&uumlr den QO 100.</h2></center> \
    <form> \
    <button name=\"But\" button style=\"color:yellow\" value=\"Dummy\" type=\"submit\"> </button> \
    <table><colgroup><col width=\"130\"> \
    <col width=\"130\"> \
   </colgroup> \n\n";
    tempStr = killBlanks(tempStr);  // String bereinigen
    //zeig("+++++++++ response 1 bereinigt" + tempStr);
    //zeigz("Ende Normal ************************************************");
    return tempStr;  // Ende von Seitenkopf
  }
}


// *******************************************************
// *** Es folgt der wesentliche Content der HTTP Antwort:
// *** Inhalt als HTML-Seite erzeugen ********************
// *******************************************************

String response2(int welche) {  // Dieser Teil kommt unter der Tabelle mitden Buttons
  String tempStr;               //
  tempStr = (String) "</table> \
  <button name=\"But\" button style=\"color:blue\" value=\"Z1\" type=\"submit\">Voreinstellungen </button> <br> \
  <table>\
  <tr>\
    <th>LNB - Modus </th>\
    <th> Frequenzstep </th>\
    <th>3. Spalte</th>\
    </tr>\
  <tr>\
    <td><input type=\"radio\" name=\"radlnbM\" value=\"OFF\""
            + modeArray[0]
            + "> Aus </td>\
    <td><input type=\"radio\" name=\"radfStep\" value=\"EINS\""
            + fStepArray[0] + "> Eins<br></td>\
    <td>1. Zeile</td>\ 
   </tr>\
   <tr>\
     <td><input type=\"radio\" name=\"radlnbM\" value=\"HOR\""
            + modeArray[1]
            + "> Horizontal</td>\
     <td><input type=\"radio\" name=\"radfStep\" value=\"VIER\""
            + fStepArray[1]
            + "> Vier</td>\
     <td>2. Zeile</td>\
    </tr>\
    <tr>\
     <td> <input type=\"radio\" name=\"radlnbM\" value=\"VERT\""
            + modeArray[2] + "> Vertikal</td>\
     <td><input type=\"radio\" name=\"radfStep\" value=\"ZEHN\""
            + fStepArray[2] + "> Zehn</td>\
     <td>3. Zeile</td>\
    </tr>\
 </table>\   
   </form>"                   // Ende von Tabelle und Form
            + systemState();  // Systemzustand hinzufügen
  return tempStr;             // Und abliefern
}


// *******************************************************
// Seitenabschluss erzeugen ******************************
// *******************************************************

String response3(int welche) {  // Für WLAN und LAN Seitenfuß erzeugen, Refresh setzen
  String tempStr = "";          //
  tempStr = "<br><br><h0>Das ist das Ende mit Schrecken, besser als ein Schrecken ohne Ende!</h0>\
    </body> \
   </html>";
  tempStr += "<meta http-equiv=\"refresh\" content=\"10; URL=http://192.168.178."  // Refresh aktivieren
             + String(gerAdr[welche]) + "\"/>\n";                                  // Leerzeile am Ende
  return killBlanks(tempStr);                                                      // Rückgabe des bereinigten Inhalts
}


// *********************************************************
// **** Antwort des Webservers senden **********************
// *********************************************************

void sendResponse(int welche) {                       // Setzt Responseteile zusammen und sendet sie
  makeArray();                                        // Feld mit Radio-Buttons anlegen
  if (welche == 0) wClient.print(response1(welche));  // Erster Teil an WLAN-Client
  else lanClient.print(response1(welche));            // oder an LAN-Client
  // *******************************************************
  // Eigentlicher Seiteninhalt
  // *******************************************************
  if (noIco) {                                            // Nach Ico-Mode kein Response
    if (page == 1) {                                      // Bedienelemente und Statusmeldungen auf Seite 1
      zeigeAlleButton(welche);                            // Nun folgt das Tabellenende, das ist etwas Aufwand
      if (welche == 0) wClient.print(response2(welche));  // Systemstatus an WLAN-Client melden
      else lanClient.print(response2(welche));            // oder an LAN-Client
    } else if (page == 2)                                 // Parameterabfrage auf Seite 2
      if (welche == 0) wClient.print(pFStrt());           // Parameterseite ins WLAN senden
      else lanClient.print(pFStrt());                     // oder in das LAN
    if (welche == 0) wClient.print(response3(welche));    // Seitenausgabe noch abschließen
    else lanClient.print(response3(welche));              // dito im LAN
  } else noIco = true;                                    // Sperre zurücksetzen
}


// *********************************************************
// Testet, ob es eine Verbindung mit einen Client gibt,
// sendet HTML-Text an ihn, der vom Browser gezeigt wird.
// Benutzer bedient ein Steuerelement, Rückabe über GET.
// WLAN und LAN
// *********************************************************

void checkWeb(int welche) {                                        // Enthält Routinen für WLAN und LAN!
  if (welche == 0) {                                               // WLAN, Paremtrisierung wäre hier sehr mühsam
    wClient = wServer.available();                                 // Horcht auf eingehend Verbindungen
    if (wClient) {                                                 // Es gibt eine Verbindung
      CurrentLine[0] = 0;                                          // String leeren
      if (report == rptWeb) zeigz("Neuer Client!");                // Bekanntgabe
      unsigned long tStart = millis();                             //
      while (wClient.connected() && (millis() - tStart < tOut)) {  // Schleife für bestehende Verbindung
        if (wClient.available()) {                                 // Falls der Client was abzuliefern hat
          char c = wClient.read();                                 // Lesen eines Zeiches
          if (report == rptin) Serial.write(c);                    // Kontrollausgabe
          int iCLL = strlen(inCommingLine);                        //
          if (iCLL < bufflen - 1) {                                // Pufferüberlauf verhindern
            inCommingLine[iCLL] = c;                               // c an Eingang anhängen
            inCommingLine[iCLL + 1] = 0;                           // Länge erhöhen
          }                                                        //
          if (c == '\n') {                                         // Falls es ein "Neue-Zeile" war
            // Falls die Zeile leer ist haben wir 2 "Neue-Zeile" in Folge.
            // Das ist das Ende des HTTP wIncomming, dann antworten wir:
            if (CurrentLine[0] == 0) {  // Ist diese letzte Zeile leer?
              // *** Response ***
              sendResponse(0);                                       // Die HTTP Antwort endet mit einer weiteren Leerzeile
              break;                                                 // Dann steigen wir aus der Schleife aus
            } else {                                                 // Nach "Neue-Zeile" wCurrrentLine löschen:
              CurrentLine[0] = 0;                                    // Puffer löschen
            }                                                        //
          } else if (c != '\r') {                                    // Falls Zeichen kein CR ist
            int cLL = strlen(CurrentLine);                           // Länge ermitteln
            if (cLL < bufflen - 1) {                                 // Kein Pufferüberlauf
              CurrentLine[cLL] = c;                                  // c anhängen
              CurrentLine[cLL + 1] = 0;                              // Länge++
            }                                                        //
          }                                                          //
        }                                                            // Ende  von client-available
      }                                                              // Ende von while
      wClient.stop();                                                // Verbindung abbauen
      if (report == rptWeb) zeigz("Web-Client Disconnected.");       // Sagen wir es de7r Welt
    }                                                                // Ende: Habe client
  }                                                                  // Ende: welche ==0
  else {                                                             // welche != 0, LAN-Modul bedienen !!!
    lanClient = server_ETH.available();                              // Horcht auf eingehend Verbindungen
    if (lanClient) {                                                 // Es gibt eine Verbindung
      CurrentLine[0] = 0;                                            // String leeren
      if (report == rptWeb) zeigz("Neuer Client!");                  // Bekanntgabe
      unsigned long tStart = millis();                               //
      while (lanClient.connected() && (millis() - tStart < tOut)) {  // Schleife für bestehende Verbindung
        if (lanClient.available()) {                                 // Falls der Client was abzuliefern hat
          char c = lanClient.read();                                 // Lesen eines Zeiches
          if (report == rptin) Serial.write(c);                      // Kontrollausgabe
          int iCLL = strlen(inCommingLine);                          //
          if (iCLL < bufflen - 1) {                                  // Pufferüberlauf verhindern
            inCommingLine[iCLL] = c;                                 // c an Eingang anhängen
            inCommingLine[iCLL + 1] = 0;                             // Länge erhöhen
          }                                                          //
          if (c == '\n') {                                           // Falls es ein "Neue-Zeile" war
            // Falls die Zeile leer ist haben wir 2 "Neue-Zeile" in Folge.
            // Das ist das Ende des HTTP wIncomming, dann antworten wir:
            if (CurrentLine[0] == 0) {  // Ist diese letzte Zeile leer?
              // *** Response ***
              sendResponse(1);                                  // HTTP senden, endet mit Leerzeile
              break;                                            // Dann steigen wir aus der Schleife aus
            } else {                                            // Nach "Neue-Zeile" wCurrrentLine löschen:
              CurrentLine[0] = 0;                               // Puffer löschen
            }                                                   //
          } else if (c != '\r') {                               // Falls Zeichen kein CR ist
            int cLL = strlen(CurrentLine);                      // Länge ermitteln
            if (cLL < bufflen - 1) {                            // Kein Pufferüberlauf
              CurrentLine[cLL] = c;                             // c anhängen
              CurrentLine[cLL + 1] = 0;                         // Länge++
            }                                                   //
          }                                                     //
        }                                                       // Ende  von client-available
      }                                                         // Ende von while
      lanClient.stop();                                         // Verbindung abbauen
      if (report == rptWeb) zeigz("Web-Client Disconnected.");  // Sagen wir es der Welt
    }                                                           // Ende: Habe Client
  }                                                             // Ende welche !=0
  // *** Nun werten wir eingegangene Daten aus:
  if (inCommingLine[0] == 0) return;                // Nichts wurde übermittelt, Ende
  if (strstr(inCommingLine, "GET /favicon.ico")) {  // Icon-Abfrage?
    ico = true;                                     // Die wolen wir nicht
  } else {                                          // Sonst ist es ein Request
    parseRequest();                                 // Request verarbeiten
  }                                                 //
  inCommingLine[0] = 0;                             // Mehrfachauswertung verhindern
}


// *********************************************************
// *** Parsen des ganzen Request ***************************
// *********************************************************

// *** Statemaschine mit den Zuständen: ***
#define los 0           // Beginn des Request-Scans
#define fragezeichen 1  // ? wurde gefunden
#define ampersand 2     // & wurde gefunden
#define gleich 4        // = wurde gefunden
#define leerzeichen 5   //  Leerzeichen wurde geleseen

// Werte von parValid
#define sValid 1
#define sMissing 0
#define sError -1

void parseRequest() {                                   // Den Requeststring lesen und aufteilen
  parReset();                                           // Erst mal alle gemerkten Requestdaten löschen
  char *GETPtr, *HostPtr;                               // Zeiger auf Teilstring mit Request-Daten
  GETPtr = strstr(inCommingLine, "GET");                // Unnötige Teile entfernen ,hinter "GET=" geht's los
  HostPtr = strstr(inCommingLine, "Host");              // Hier beginnt der Host-Abschnitt
  if (GETPtr != 0) {                                    // GET-Request, Daten isolieren
    uint16_t ende = 0;                                  // Start im ersten Zeiten von GetPtr
    while (GETPtr[ende] != 10) ende++;                  // Zeilenende suchen
    GETPtr[ende] = 0;                                   // Rest des Request löschen
    inNr = 0;                                           // Ersten Parameter suchen, Index ist 0
    parStatus[inNr] = sMissing;                         // Dieser Parameter fehl noch
    uint16_t sta = los;                                 // Beginn des Scans
    for (uint16_t wo = 0; wo < strlen(GETPtr); wo++) {  // Alle Zeichen in State-Machine bearbeiten
      switch (sta) {                                    // Abhängig vom Status:
        case los:                                       //
          if (GETPtr[wo] == '?') {                      // ? gefunden
            sta = fragezeichen;                         // Staus entsprechend ändern
            parName[inNr] = "";                         // Parameter name wird gesucht, Startwert: leer
          }                                             //
          break;                                        //
        case fragezeichen:                              // Ersten Parameternamen gefunden
          parStatus[inNr] = sMissing;                   // Noch gibt es den nicht
          if (GETPtr[wo] == '=') {                      // = gefunden
            sta = gleich;                               // Status wechseln
            parValue[inNr] = "";                        // Noch gibt es den Wert nicht
          } else parName[inNr] += GETPtr[wo];           // Sonst Zeichen an Namen anhängen
          break;                                        // Einsammeln
        case gleich:                                    // Parameterwert beginnt hier
          if (GETPtr[wo] == ' ') {                      // Leerzeichen gefunden, hier ist Schluss
            sta = leerzeichen;                          // Statuswechsel
            parStatus[inNr] = sValid;                   // Parameter ist gültig
            inNr++;                                     // Parameter vollständig, fertig
          } else if (GETPtr[wo] == '&') {               // & gefunden
            sta = ampersand;                            // Statuswechsel
            parStatus[inNr] = sValid;                   // Parameter vollständig, nächster
            inNr++;                                     // Parameterzähler erhöhen
            parName[inNr] = "";                         // Parametername ist erst mal leer
          } else parValue[inNr] += GETPtr[wo];          //
          break;                                        // Parameterwert aufnehmen
        case ampersand:                                 // Start weiterer Parameter
          parStatus[inNr] = sMissing;                   // Der Parameter fehlt aber noch
          if (GETPtr[wo] == '=') {                      // = gefunden
            sta = gleich;                               // Statuswechsel
            parValue[inNr] = "";                        // Hier beginnt dei Wertangabe
          } else parName[inNr] += GETPtr[wo];           //
          break;                                        // Parametername aufnehmen
      }                                                 //
    }                                                   //
    if (report == rptWeb) {                             // Bei Bedarf die Fundstücke zeigen
      zeigz("Emfangen:");                               //
      for (uint16_t i = 0; i < inNr; i++) {             //
        zeig((String)i + "  Name:" + parName[i]);       //
        zeig(" Wert:" + parValue[i]);                   //
        zeigz("   Valid:" + parStatus[i]);              //
      }                                                 //
      zeigz("Ende Empfang");                            //
    }                                                   //
    useRequest();                                       // Den Request verarbeiten
  }                                                     //
  if (HostPtr != 0) {                                   // Host isolieren
    HostStr = "";                                       //
    uint16_t p = 6;                                     // Aufbau: Host xxx.xxx.xxx.xxx
    while (HostPtr[p] != '\n') {                        //
      HostStr += HostPtr[p];                            //
      p++;                                              //
    }                                                   //
    if (report == rptWeb)                               //
      zeigz("Request für " + HostStr);                  //
  }
}


// *********************************************************
// *** Request der Verwendung zuführen *********************
// *********************************************************

void useRequest() {
  bool needRestart = false;                                                         //
  if (report == rptWeb) zeigz("Verwende Request: ");                                //
  for (uint16_t inNr = 0; inNr < parZahl; inNr++) {                                 // Schleife über alle Rückmeldungen
    ;                                                                               // Zuerst Buttons abarbeiten
    if ((parStatus[inNr] == sValid) && (parName[inNr].substring(0, 3) == "But")) {  // Kennzeichen für Knopf
      if (parValue[inNr].length() < 2) parValue[inNr] += " ";                       // Länge eventuell erhöhen
      char art = parValue[inNr].charAt(0);                                          // Aufteilen...
      char nr = parValue[inNr].charAt(1);                                           // ... zwei Informationen
      char was = ' ';                                                               // Hier unnötig, bleibt leer
      if (report == rptWeb)                                                         //
        zeigz((String) "Art=" + art + " nr=" + nr + " was=" + was);                 //
      if ((parValue[inNr] == "Z1") || (parValue[inNr] == "E1")) {                   // Knöpfe mit Sonderfunktion
        page = 2;                                                                   // Zur Parametereinagabe
      } else                                                                        //
        if ((parValue[inNr] == "Z2") || (parValue[inNr] == "Z3")) {                 // Knöpfe mit Sonderfunktion
          page = 1;                                                                 // Zurück zur Normalansicht
        }                                                                           // Ende Sonderfunktion
        else                                                                        //
          useButtonData(art, nr, was);                                              // Empfang der Verwendung zuführen
    }                                                                               // Ende: Es ist ein Knopf
    ;                                                                               // Radiobuttons folgen
    if ((parStatus[inNr] == sValid) && (parName[inNr].substring(0, 3) == "rad")) {  // Kennzeichen für Radiobutton
      String name = parName[inNr].substring(3, 255);                                // Vorsilbe "rad" abschneiden
      String wert = parValue[inNr];                                                 //
      char was = ' ';                                                               //
      if (report == rptWeb)                                                         //
        zeigz((String) "Radiobutton " + " Name=" + name + " Wert=" + wert);         //
      if (name.compareTo("lnbM") == 0) {                                            // LNB-Modus setzen!
        if ((wert.compareTo("OFF") == 0) && (lnbM != OFF)) setLNB(OFF);             // Falls nötig tun wir es!
        if ((wert.compareTo("VERT") == 0) && (lnbM != VERT)) setLNB(VERT);          //
        if ((wert.compareTo("HOR") == 0) && (lnbM != HOR)) setLNB(HOR);             //
      }                                                                             //
      if (name.compareTo("fStep") == 0) {                                           //  LNB-Schrittweite setzen
        if ((wert.compareTo("EINS") == 0) && (lnbF != EINS)) { lnbF = EINS; }       //
        if ((wert.compareTo("VIER") == 0) && (lnbF != VIER)) { lnbF = VIER; }       //
        if ((wert.compareTo("ZEHN") == 0) && (lnbF != ZEHN)) { lnbF = ZEHN; }       //
      }
    }                                                                                // Ende: Es ist ein Radiobutton
    ;                                                                                // Voreinstellungen auf Seite 2, incl. Checkboxen bearbeiten
    if ((parStatus[inNr] == sValid) && (parName[inNr].substring(1, 5) == "wert")) {  // Kennzeichen solcher Rückmeldungen
      stElNr = parName[inNr].substring(5).toInt();                                   // Nummer des Steuerelements isolieren
      if (report == rptWeb) {                                                        // Kontrolle
        zeig((String) "Präfix:" + parName[inNr].substring(1, 5));                    //
        zeig((String) " Postfix:" + stElNr);                                         //
        zeigz((String) " bekommt Wert:" + parValue[inNr]);                           //
      }                                                                              //
      if ((stElNr >= 0) && (stElNr < parZahl - 1)) {                                 // Nr. des Eingabeelementes ist gültig
        switch (stElNr / ipZahl) {                                                   // Gleich viele Par. je Typ, sonst geht das nicht!
          case 0:                                                                    // iPar
            if (iPar.getWert(stElNr) != parValue[inNr].toInt()) {                    // iPar-Wert geändert?
              iPar.setWert(stElNr, parValue[inNr].toInt());                          // Wert in Parameterliste schreiben
              iParChanged(stElNr);                                                   // Änderung anwenden
            }                                                                        //
            break;                                                                   // Ende iPar
          case 1:                                                                    // sPar
            if (!sPar.getWert(stElNr - ipZahl).equals(parValue[inNr])) {             // Wird sPar geändert?
              sPar.setWert(stElNr - ipZahl, parValue[inNr]);                         // String in Parameterliste schreiben
              if ((stElNr == sSSID) || (stElNr == sPassword)) needRestart = true;    // Diese Paraameter  wirken nur nach Neustart
              sParChanged(stElNr - ipZahl);                                          // Änderung anwenden
            }                                                                        //
            break;                                                                   // Ende sPar
          case 2:                                                                    // bPar, hier landen nur gecheckte Boxen!
                                                                                     // bool tempStr = (parValue[inNr] == "1"); // Box checked?, sollte so sein
            uint16_t index = stElNr - ipZahl - spZahl;                               // Index für b-Parameterfeld
            boxes[index] = true;                                                     // Merke gescheckte Box
            bPar.setWert(index, true);                                               //
            aBoxChecked = true;                                                      // Merker: Wenigsten eine Box ist gesetzt
            break;                                                                   // Ende bPar
        }                                                                            // Ende "switch"
      }                                                                              // Ende "gültige StElNr"
    }                                                                                // "Gültiger Rückgabewert"
  }                                                                                  // Schleife über alle Rückmeldungen
  for (uint16_t b = 0; b < bpZahl; b++) {                                            // Alle Checkboxen
    if (aBoxChecked) {                                                               // Wenigstens eine Box ist als checked gemeldet
      if ((bPar.getWert(b)) && (!boxes[b])) {                                        // bParameterwert gesetzt, Boxes aber nicht
        zeig(String(b) + " Reset   ");                                               //
        bPar.setWert(b, false);                                                      // bParameter zurücksetzen
      }                                                                              // Änderung nötig
      boxes[b] = false;                                                              // Boxes-Wert rücksetzen
    }                                                                                //
  }                                                                                  // Eine Box ist checked gemeldet
  aBoxChecked = false;                                                               // Merker zurücksetzen
  if (report == rptWeb) zeigz("Request ist verwendet.");                             //
  if (iPar.isDirty()) iPar.writeThem();                                              // Geänderte Parameter sichern
  if (sPar.isDirty()) sPar.writeThem();                                              //
  if (bPar.isDirty()) bPar.writeThem();                                              //
  if (needRestart) esp_restart();                                                    // Eventuell Neustart
}
