// *******************************************************
// *** Webserver LAN viaa W5500 **************************
// *** Minimierung des Stringgebrauchs *******************
// *** Verbesserte Requestbehandlung *********************
// *** Timeout beim Check-Web ****************************
// *** Verwendet Systemparameter *************************
// *** Funktionalität weitgehend ausgegliedert ***********
// *************  Oktober 2025  **************************

#include <SPI.h>
// #include <Ethernet2.h>         // Vorgezogen inHeader
// EthernetServer server_ETH(80); //Vorgeogen in Header

byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
;                                      // Pindefinitionen
static const uint8_t resetW5500 = 26;  // Portnummer für Reset
#define WIZ_CS 27                      // CS-Port des W5500
boolean lanReady = false;              // Haben wir eine Lanverbindung?


// *********************************************************
// *** Setup ***********************************************
// *** Muss geprüft werden *********************************
// *********************************************************

void setupW5500() {
  zeigz("LAN-Modul starten:");                          // Reset ist wahrscheinlich unnötig
  pinMode(resetW5500, OUTPUT);                          // Reset W5500 GPIO 0
  setze(resetW5500, LOW);                               // Impuls auf Reset-Leitung
  delay(20);                                            //
  setze(resetW5500, HIGH);                              //
  delay(20);                                            // Fertig!
  Ethernet.init(WIZ_CS);                                // Starten wir das Modul
  delay(100);                                           // Das Modul benötigt etwas Zeit
  Ethernet.begin(mac, local_Lan);                       // Los geht es
  delay(100);                                           // Pause für das Modul
  if (Ethernet.hardwareStatus() == EthernetNoHardware)  // Erfolgskontrolle
    zeigz("Ehternetmodul nicht gefunden");              //
  else {                                                //
    zeigz("Ethernetmodul gefunden");                    // Erfolg
    server_ETH.begin();                                 // Server starten
    delay(100);                                         // Auch das dauert eine Weile
    zeigz("Webserver LAN gestartet!");                  //
    if (Ethernet.linkStatus() != LinkOFF) {             //
      zeigz("Kabelverbindung ist vorhanden");           //
      lanReady = true;                                  // Noch einmal Erfolg
    }                                                   //
  }                                                     //
}