// ****************************************************************
// ************* Watchdog-Modul 14.06.2024 ************************
// ************* Tageswechselprüfung geändert *********************
// ************* Structure bei Init neu nach Softwareupdate *******
// ****************************************************************

#include "esp_system.h"        // System Library
#include <esp_task_wdt.h>      //Load Watchdog-Library
#define rptWatchdog 'R' - '0'  // Reportcode Watchdog

esp_task_wdt_config_t wdt_config = {
  // Konfigurationsdaten Watchdog
  .timeout_ms = 30000,   // Erforderlich nach Update der Boardsoftware
  .idle_core_mask = 0,   // Parameter für Init
  .trigger_panic = true  // und reconfigure (statt reset)
};

// ****************************************************************
// ************* Initialisierung, macht den Watchdog scharf *******
// ****************************************************************

void setupWatchDog() {
  esp_task_wdt_init(&wdt_config);  // Init Watchdog with TIMEOUT 20 s and panicmode
  esp_task_wdt_add(NULL);          // No special task needed
}


// ****************************************************************
// *** Serviceroutine, ResetTimer auf 0 oder Reset ****************
// ****************************************************************

void checkWatchDog() {
  if (report == rptWatchdog) esp_restart();  // Sofortiger Neustart
  if (report == 'Z' - '0') return;           // Software-Watchdog testen: Triggerung abschalten
  if (WiFi.status() == WL_CONNECTED)         //
    if (tageswechsel()) esp_restart();       // Neustart bei Tageswechsel mit WiFi durch Blocken des Timerreset
  esp_task_wdt_reconfigure(&wdt_config);     // enable panic so ESP32 restarts at timeout
}