// ********************************************************
// *** Sonstiges, interne Hilfsroutinen *******************
// *** Zeitgesteuerte Ereignisse erzeugen *****************
// ********************************************************

#define rptSonst 'S' - '0'
// Hilfsvariablen für Erzeugung der Timeslices
unsigned long millis100, millis1000, millis10000, millis60000;
int minCnt = 0;


// ********************************************************
// ***Operationen, die selten ausgeführt werden müssen ***
// ********************************************************

void loop1min() {
  // zeigz("one min");
  checkNTP();
  minCnt++;
  if (report == rptSonst) zeigz("Minutentakt");
}


// ********************************************************
// *** Mittelmäßig dringende Operationen ******************
// ********************************************************

void loop10s() {
  // zeigz("ten seconds");
  checkNTP();                              // NTP-Dienst befragen
  checkFan();                              // Lüfter kontrollieren
  if (report == rptSensor) showSensors();  // Sensordaten anzeigen
}


// ********************************************************
// *** Regelmäßige Operationen ****************************
// ********************************************************

void loop1s() {
  if (report == ('S' - '0')) scanI2C();  //
  checkWLAN();                           // WLAN Talk-Modus kontrollieren
  if (report == rptVor) {                // Gespeicherte Voreinstellungen zurücksetzen
    sPar.killThemAll();                  // Löscht alle IPar auf SSD
    iPar.killThemAll();                  // Löscht alle SPar auf SSD
    bPar.killThemAll();                  // Löscht alle bPar auf SSD
    esp_restart();                       // Neustart, Werkseinstellungen aktivieren
  }                                      //
  liesPTT();                             // Zusatzeingänge auslesen
  checkSensors();                        // Sensoren abfragen
}


// ********************************************************
// *** Regelmäßige Operationen ****************************
// ********************************************************

void loop100ms() {                           // Reihenfolge so einhalten!
  checkADS();                                // Spannungen messen
  checkVoltages();                           // Einhalten der Limits prüfen
  checkPTT();                                // PTT-Tastenzustand verwerten
  checkSWR();                                // SWR bestimmen, wenn nötig abchalten
  checkTasten();                             // Eingaben für LNB
  if (report == ('Y' - '0')) esp_restart();  // Sofortiger Neustart
}


// ********************************************************
// *** Timeslices generieren ****************************
// ********************************************************

void dispatchTimeSlices() {
  if ((millis() - millis100) >= 100L) {
    loop100ms();  // Zeitsteuerung anstoßen
    millis100 = millis();
  }
  if ((millis() - millis1000) >= 1000L) {
    loop1s();  // Zeitsteuerung anstoßen
    millis1000 = millis();
  }
  if ((millis() - millis10000) >= 10000L) {
    loop10s();  // Zeitsteuerung anstoßen
    millis10000 = millis();
  }
  if ((millis() - millis60000) >= 60000L) {
    loop1min();  // Zeitsteuerung anstoßen
    millis60000 = millis();
  }
}
