// ********************************************************
// ***  Main **********************************************
// ********************************************************


#define rptMain 'A' - '0'
boolean netzStarted = false;  // Wird mit WiFi-Start gesetzt

void setup() {
  netzStarted = false;                       //
  minCnt = 0;                                //
  Serial.begin(115200);                      // Ausgaben ermöglichen
  zeigz("Scheiße im Prozessorkern");         //
  zeigz("sieht man nicht besonders gern.");  //
  setupPref();                               // Zuerst,andere Module nutzen Prefs
  setupW5500();                              // Lan-Modul
  setupWiFi();                               // Dringend, viele Module brauchen das
  lastDay = day();                           // Falsche Tageswechselerkennung verhindern
  setupTools();                              // Led-Anzeigen
  setupPorts();                              // Ausgänge, Fan, LNB, PTT
  setupSensors();                            // AD1115, Tasten, DS18B20
  setupIn();                                 // Eingänge, Zusatzfunktionen
  setupWatchDog();                           // Timer-WD starten
}


// ********************************************************
// **** Setup nach WiFi-Connect ***************************
// ********************************************************

void setupMitNetz() {                       // Das Netz läuft, jetzt können weitere Module folgen
  zeigz("Weitere Module initialisieren.");  //
  netzStarted = true;                       // Start erfolgt nur einmal
  checkWatchDog();                          //
  setupNTP();                               // Nun die Uhrzeit erfassen
  checkWatchDog();                          //
  setupWlanWeb();                           // Webserver starten
  setupData();                              //
}

// ********************************************************
// **** Mainloop ******************************************
// ********************************************************

void loop() {
  checkPorts();                        // Portmanager
  if ((WiFiOK) || (lanReady)) {        // Für folgende Aktionen brauchen wir das Netz:
    if (!netzStarted) setupMitNetz();  // Einmalig: Setup für das Netz ausführen
    else {                             // Ansonsten:
      checkWeb(1);                     // LanWebserver bedienen
      checkWatchDog();                 // Watchdog triggern
      checkWeb(0);                     // WLanWebserver
      checkWatchDog();                 // Watchdog triggern
      checkData();                     // Datenmodul bedienen, lauscht auf Anforderungen über das Netz
    }                                  //
  }                                    //
  doKeyboard();                        // Tastaturabfrage vornehmen
  checkWatchDog();                     // Watchdog triggern
  dispatchTimeSlices();                // Zeitsteuerung anstoßen
}
